/*
 * Decompiled with CFR 0.152.
 */
package com.ktar5.infoboard.Scoreboard;

import com.ktar5.infoboard.Scoreboard.FastOfflinePlayer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Board {
    private Scoreboard scoreboard;
    private Objective objective;

    public Board() {
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.setup();
    }

    public Board(Player player) {
        this.scoreboard = player.getScoreboard();
        this.objective = this.scoreboard.getObjective(DisplaySlot.SIDEBAR);
    }

    public Board(Scoreboard board) {
        this.scoreboard = board;
        this.objective = board.getObjective(DisplaySlot.SIDEBAR);
    }

    public void add(String line, int row) {
        row = 15 - row;
        if (line.length() > 16) {
            this.addCreatingTeam(line, row);
        } else {
            Score score = this.objective.getScore(line);
            score.setScore(1);
            score.setScore(row);
        }
    }

    private void addCreatingTeam(String line, int row) {
        String prefix = null;
        String name = null;
        String suffix = null;
        if (line.length() > 48) {
            line = line.substring(0, 47);
        }
        if (line.length() <= 16) {
            name = line;
        } else if (line.length() <= 32) {
            name = line.substring(0, 16);
            suffix = line.substring(16, line.length());
        } else {
            prefix = line.substring(0, 16);
            name = line.substring(16, 32);
            suffix = line.substring(32, line.length());
        }
        FastOfflinePlayer op = new FastOfflinePlayer(name);
        if (prefix != null || suffix != null) {
            Team team = this.scoreboard.getPlayerTeam((OfflinePlayer)op);
            if (team == null) {
                team = this.scoreboard.registerNewTeam(name);
            }
            team.addPlayer((OfflinePlayer)op);
            if (prefix != null) {
                team.setPrefix(prefix);
            }
            team.setSuffix(suffix);
        }
        Score score = this.objective.getScore(name);
        score.setScore(1);
        score.setScore(row);
    }

    public Score getScore(String line) {
        return this.objective.getScore(line);
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public String getTitle() {
        return this.objective.getDisplayName();
    }

    public void remove(String line) {
        this.scoreboard.resetScores(line);
        if (this.scoreboard.getTeam(line) != null) {
            this.scoreboard.getTeam(line).unregister();
        }
    }

    public void setTitle(String title) {
        this.objective.setDisplayName(title);
    }

    private void setup() {
        this.objective = this.scoreboard.registerNewObjective("InfoBoard", "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    public void update(String line, int row) {
        String name = null;
        name = line.length() <= 16 ? line : (line.length() <= 32 ? line.substring(0, 16) : line.substring(16, 32));
        if (!this.scoreboard.getEntries().contains(name)) {
            for (String op : this.scoreboard.getEntries()) {
                if (this.objective.getScore(op).getScore() != 15 - row) continue;
                this.remove(op);
                break;
            }
            this.add(line, row);
        }
    }
}

