/*
 * Decompiled with CFR 0.152.
 */
package com.ktar5.infoboard.API;

import com.ktar5.infoboard.Util.Settings;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class WorldGuard {
    public static boolean boardsAllowedHere(Location loc) {
        boolean allowed = true;
        if (WorldGuard.hasWorldGuardOnServer()) {
            for (ProtectedRegion region : WorldGuard.getRegionsIn(loc)) {
                if (!Settings.getRegionsDisabled().contains(region.getId())) continue;
                allowed = false;
            }
        }
        return allowed;
    }

    private static ArrayList<ProtectedRegion> getRegionsIn(Location loc) {
        ArrayList<ProtectedRegion> inRegions = new ArrayList<ProtectedRegion>();
        WorldGuardPlugin wg = (WorldGuardPlugin)Bukkit.getPluginManager().getPlugin("WorldGuard");
        RegionManager regions = wg.getRegionManager(loc.getWorld());
        for (ProtectedRegion protectedRegion : regions.getApplicableRegions(loc)) {
            inRegions.add(protectedRegion);
        }
        return inRegions;
    }

    private static boolean hasWorldGuardOnServer() {
        return Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
    }
}

