/*
 * Decompiled with CFR 0.152.
 */
package com.ktar5.infoboard.API;

import com.ktar5.infoboard.InfoBoard;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Vault {
    public static String getRank(Player player) {
        String rank = "default";
        if (Vault.hasVaultOnServer()) {
            try {
                rank = InfoBoard.permission.getPlayerGroups(player.getWorld().getName(), (OfflinePlayer)player.getPlayer())[0];
            }
            catch (UnsupportedOperationException e) {
                System.out.println("---------------------------------------------------------");
                System.out.println("");
                System.out.println("InfoBoard will be shut down because there is a problem with your server's permissions");
                System.out.println("");
                System.out.println("---------------------------------------------------------");
                Bukkit.getPluginManager().disablePlugin(InfoBoard.instance);
            }
        }
        return rank;
    }

    private static boolean hasVaultOnServer() {
        return Bukkit.getPluginManager().getPlugin("Vault") != null && InfoBoard.permission != null && InfoBoard.permissionB;
    }

    public static boolean load() {
        if (!Vault.setupEconomy() || !Vault.setupPermissions()) {
            System.out.println("---------------------------------------------------------");
            System.out.println("");
            System.out.println("InfoBoard will be shut down because VAULT either does not have economy or permissions setup");
            System.out.println("");
            System.out.println("---------------------------------------------------------");
            return false;
        }
        return true;
    }

    private static boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            InfoBoard.economy = (Economy)economyProvider.getProvider();
        }
        if (InfoBoard.economy != null) {
            InfoBoard.economyB = true;
        }
        return InfoBoard.economy != null;
    }

    private static boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            InfoBoard.permission = (Permission)permissionProvider.getProvider();
        }
        if (InfoBoard.permission != null) {
            InfoBoard.permissionB = true;
        }
        return InfoBoard.permission != null;
    }
}

