/*
 * Decompiled with CFR 0.152.
 */
package maxpowa.weatherlock.listeners;

import maxpowa.weatherlock.WeatherLock;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WorldListener
implements Listener {
    private WeatherLock plugin;

    public WorldListener(WeatherLock plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWeatherChange(WeatherChangeEvent event) {
        World world = event.getWorld();
        boolean rain = event.toWeatherState();
        if (rain) {
            if (!this.plugin.worldsConfig.get().getBoolean(String.valueOf(world.getName()) + ".rain")) {
                event.setCancelled(true);
            }
        } else if (!this.plugin.worldsConfig.get().getBoolean(String.valueOf(world.getName()) + ".sun")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onThunderChange(ThunderChangeEvent event) {
        World world = event.getWorld();
        boolean storm = event.toThunderState();
        if (storm) {
            if (!this.plugin.worldsConfig.get().getBoolean(String.valueOf(world.getName()) + ".storm")) {
                event.setCancelled(true);
            }
        } else if (this.plugin.getWeather(world).equalsIgnoreCase("storm") && !this.plugin.worldsConfig.get().getBoolean(String.valueOf(world.getName()) + ".rain")) {
            event.setCancelled(true);
        }
    }
}

