/*
 * Decompiled with CFR 0.152.
 */
package maxpowa.weatherlock;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import maxpowa.weatherlock.ConfigHandler;
import maxpowa.weatherlock.listeners.WorldListener;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WeatherLock
extends JavaPlugin {
    public static final Logger logger = Logger.getLogger("Minecraft");
    public String name;
    public String prefix;
    public ConfigHandler worldsConfig;
    public Map<Integer, Sign> signs = new HashMap<Integer, Sign>();

    public void onDisable() {
        logger.info(String.valueOf(this.name) + "Disabled!");
        super.onDisable();
    }

    public void onEnable() {
        this.name = "[WL] ";
        this.prefix = ChatColor.DARK_AQUA + this.name + ChatColor.RESET;
        this.worldsConfig = new ConfigHandler((Plugin)this, "worlds");
        this.loadConfigs();
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
        logger.info(String.valueOf(this.name) + "Enabled!");
        super.onEnable();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 4) {
            sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Too many arguments!");
            sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "If there are spaces in your world name, surround the name in \" quotations marks. (Ex; \"My World\")");
        }
        Player player = null;
        player = this.getServer().getPlayerExact(sender.getName());
        if (label.equalsIgnoreCase("weatherlock") || label.equalsIgnoreCase("wl") || label.equalsIgnoreCase("wlock")) {
            if (args.length == 0) {
                if (sender.hasPermission("weatherLock")) {
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.UNDERLINE + "WeatherLock:");
                    sender.sendMessage(String.valueOf(this.prefix) + "Version: " + this.getDescription().getVersion());
                    sender.sendMessage(String.valueOf(this.prefix) + "Author: maxpowa");
                    sender.sendMessage(String.valueOf(this.prefix) + "Website: " + ChatColor.BLUE + this.getDescription().getWebsite());
                    sender.sendMessage(String.valueOf(this.prefix) + "Type '/weatherlock help' for more help!");
                }
                return true;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("help")) {
                    if (sender.hasPermission("weatherLock.help")) {
                        sender.sendMessage(String.valueOf(this.prefix) + ChatColor.UNDERLINE + "Help:");
                        sender.sendMessage(String.valueOf(this.prefix) + "WeatherLock uses the aliases /wl and /wlock");
                        sender.sendMessage(String.valueOf(this.prefix) + "/weatherlock <sun|rain|storm|info> [world]");
                        sender.sendMessage(String.valueOf(this.prefix) + "/weatherlock set [world] <sun|rain|storm> <true|false>");
                    }
                    return true;
                }
                if (player != null) {
                    World world = player.getWorld();
                    if (args[0].equalsIgnoreCase("sun") || args[0].equalsIgnoreCase("rain") || args[0].equalsIgnoreCase("storm")) {
                        return this.setWeather(world, args, sender);
                    }
                    if (args[0].equalsIgnoreCase("info")) {
                        return this.checkWeather(world, args, sender);
                    }
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Incorrect command parameters. Syntax: /weatherlock <sun|rain|storm|info> [world]");
                } else {
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Sorry, you must specify a world if you run this command from console.");
                }
            } else if (args.length == 2) {
                World world = this.getServer().getWorld(args[1]);
                if (world != null) {
                    if (args[0].equalsIgnoreCase("sun") || args[0].equalsIgnoreCase("rain") || args[0].equalsIgnoreCase("storm")) {
                        return this.setWeather(world, args, sender);
                    }
                    if (args[0].equalsIgnoreCase("info")) {
                        return this.checkWeather(world, args, sender);
                    }
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Incorrect command parameters. Syntax: /weatherlock <sun|rain|storm|info> [world]");
                } else {
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Incorrect command parameters. Syntax: /weatherlock <sun|rain|storm|info> [world]");
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "If there are spaces in your world name, surround the name in \" quotations marks. (Ex; \"My World\")");
                }
            } else if (args.length == 4) {
                if (args[0].equalsIgnoreCase("set")) {
                    if (this.getServer().getWorld(args[1]) != null && (args[2].equalsIgnoreCase("sun") || args[2].equalsIgnoreCase("rain") || args[2].equalsIgnoreCase("storm")) && (args[3].equalsIgnoreCase("true") || args[3].equalsIgnoreCase("false"))) {
                        this.worldsConfig.set(String.valueOf(args[1]) + "." + args[2], args[3].equalsIgnoreCase("true"));
                        sender.sendMessage(String.valueOf(this.prefix) + "Set weathertype " + args[2] + " to " + args[3] + " in \"" + args[1] + "\"");
                        return true;
                    }
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Incorrect command parameters. Syntax: /weatherlock set [world] <sun|rain|storm> <true|false>");
                }
                sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Incorrect command parameters. See /weatherlock help for command information.");
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("set")) {
                    if (player != null) {
                        String worldName = player.getWorld().getName();
                        if (args[1].equalsIgnoreCase("sun") || args[1].equalsIgnoreCase("rain") || args[1].equalsIgnoreCase("storm")) {
                            if (args[2].equalsIgnoreCase("true") || args[2].equalsIgnoreCase("false")) {
                                this.worldsConfig.set(String.valueOf(worldName) + "." + args[1], args[2].equalsIgnoreCase("true"));
                                sender.sendMessage(String.valueOf(this.prefix) + "Set weathertype " + args[1] + " to " + args[2] + " in \"" + worldName + "\"");
                                return true;
                            }
                        } else {
                            sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Incorrect command parameters. Syntax: /weatherlock set [world] <sun|rain|storm> <true|false>");
                        }
                    } else {
                        sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Sorry, you must specify a world if you run this command from console.");
                    }
                } else {
                    sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Incorrect command parameters. See /weatherlock help for command information.");
                }
            }
        }
        return true;
    }

    private boolean checkWeather(World world, String[] args, CommandSender sender) {
        if (sender.hasPermission("weatherGod.info")) {
            sender.sendMessage(String.valueOf(this.prefix) + "It's currently " + this.getWeather(world) + ". " + this.getWeatherConfig(world) + ChatColor.RESET + ".");
        }
        return true;
    }

    private boolean setWeather(World world, String[] args, CommandSender sender) {
        if (sender.hasPermission("weatherLock." + args[0].toLowerCase())) {
            if (!this.worldsConfig.get().getBoolean(String.valueOf(world.getName()) + "." + args[0].toLowerCase())) {
                sender.sendMessage(String.valueOf(this.prefix) + ChatColor.RED + "Weather can't be set to " + args[0].toLowerCase() + " in \"" + world.getName() + "\"");
                return true;
            }
            if (args[0].equalsIgnoreCase("sun")) {
                world.setStorm(false);
            } else if (args[0].equalsIgnoreCase("rain")) {
                world.setThundering(false);
                world.setStorm(true);
            } else if (args[0].equalsIgnoreCase("storm")) {
                world.setThundering(true);
            }
            sender.sendMessage(String.valueOf(this.prefix) + "Weather set to sun in: " + world.getName());
        }
        return true;
    }

    public void loadConfigs() {
        this.getConfig().options().header("Configuration");
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.worldsConfig.get().options().header("Configuration -> worlds");
        for (World world : this.getServer().getWorlds()) {
            if (world.getEnvironment() != World.Environment.NORMAL) continue;
            this.worldsConfig.get().addDefault(String.valueOf(world.getName()) + ".sun", (Object)true);
            this.worldsConfig.get().addDefault(String.valueOf(world.getName()) + ".rain", (Object)true);
            this.worldsConfig.get().addDefault(String.valueOf(world.getName()) + ".storm", (Object)true);
        }
        this.worldsConfig.get().options().copyDefaults(true);
        this.worldsConfig.save();
    }

    public void reloadConfigs() {
        this.loadConfigs();
        this.reloadConfig();
        this.worldsConfig.reload();
    }

    public String getWeather(World world) {
        if (world.isThundering()) {
            return "stormy";
        }
        if (world.hasStorm() && !world.isThundering()) {
            return "raining";
        }
        return "sunny";
    }

    private String getWeatherConfig(World world) {
        String worldName = world.getName();
        boolean sun = this.worldsConfig.get().getBoolean(String.valueOf(worldName) + ".sun");
        boolean rain = this.worldsConfig.get().getBoolean(String.valueOf(worldName) + ".rain");
        boolean storm = this.worldsConfig.get().getBoolean(String.valueOf(worldName) + ".storm");
        return ChatColor.RESET + "Sun is " + (sun ? ChatColor.GREEN + "enabled" : ChatColor.RED + "disabled") + ChatColor.RESET + ". Rain is " + (rain ? ChatColor.GREEN + "enabled" : ChatColor.RED + "disabled") + ChatColor.RESET + ". Storms are " + (storm ? ChatColor.GREEN + "enabled" : ChatColor.RED + "disabled");
    }
}

