/*
 * Decompiled with CFR 0.152.
 */
package maxpowa.weatherlock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigHandler {
    private Plugin plugin;
    private String name;
    private String path;
    private FileConfiguration config = null;
    private File configFile = null;

    public ConfigHandler(Plugin plugin, String name, String path) {
        this.plugin = plugin;
        this.name = name;
        this.path = path;
    }

    public ConfigHandler(Plugin plugin, String name) {
        this(plugin, name, plugin.getDataFolder().getPath());
    }

    public FileConfiguration get() {
        if (this.config == null) {
            this.reload();
        }
        return this.config;
    }

    public void reload() {
        if (this.configFile == null) {
            this.configFile = new File(this.path, String.valueOf(this.name) + ".yml");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defaultConfigStream = this.plugin.getResource(String.valueOf(this.name) + ".yml");
        if (defaultConfigStream != null) {
            this.config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((InputStream)defaultConfigStream));
        }
    }

    public void set(String path, boolean b) {
        this.get().set(path, (Object)b);
        this.save();
    }

    public void save() {
        if (this.config == null || this.configFile == null) {
            return;
        }
        try {
            this.get().save(this.configFile);
        }
        catch (IOException exception) {
            this.plugin.getLogger().severe("Could not save config '" + this.name + ".yml'!\n" + exception.getMessage());
        }
    }
}

