/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.packetlistener.channel;

import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.ArrayList;
import net.minecraft.util.io.netty.channel.Channel;
import net.minecraft.util.io.netty.channel.ChannelDuplexHandler;
import net.minecraft.util.io.netty.channel.ChannelHandlerContext;
import net.minecraft.util.io.netty.channel.ChannelPromise;
import org.bukkit.entity.Player;
import org.inventivetalent.packetlistener.Cancellable;
import org.inventivetalent.packetlistener.IPacketListener;
import org.inventivetalent.packetlistener.channel.ChannelAbstract;
import org.inventivetalent.packetlistener.channel.ChannelWrapper;
import org.inventivetalent.packetlistener.reflection.minecraft.Minecraft;

public class NMUChannel
extends ChannelAbstract {
    private static final Field channelField = networkManagerFieldResolver.resolveByFirstTypeSilent(Channel.class);

    public NMUChannel(IPacketListener iPacketListener) {
        super(iPacketListener);
    }

    @Override
    public void addChannel(final Player player) {
        try {
            final Channel channel = this.getChannel(player);
            this.addChannelExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        channel.pipeline().addBefore("packet_handler", "packet_listener_player", (net.minecraft.util.io.netty.channel.ChannelHandler)new ChannelHandler(player));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to add channel for " + player, e);
        }
    }

    @Override
    public void removeChannel(Player player) {
        try {
            final Channel channel = this.getChannel(player);
            this.removeChannelExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (channel.pipeline().get("packet_listener_player") != null) {
                            channel.pipeline().remove("packet_listener_player");
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to remove channel for " + player, e);
        }
    }

    Channel getChannel(Player player) throws ReflectiveOperationException {
        Object handle = Minecraft.getHandle(player);
        Object connection = playerConnection.get(handle);
        return (Channel)channelField.get(networkManager.get(connection));
    }

    @Override
    public ChannelAbstract.IListenerList newListenerList() {
        return new ListenerList();
    }

    class NMUChannelWrapper
    extends ChannelWrapper<Channel>
    implements ChannelAbstract.IChannelWrapper {
        public NMUChannelWrapper(Channel channel) {
            super(channel);
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return ((Channel)this.channel()).remoteAddress();
        }

        @Override
        public SocketAddress getLocalAddress() {
            return ((Channel)this.channel()).localAddress();
        }
    }

    class ChannelHandler
    extends ChannelDuplexHandler
    implements ChannelAbstract.IChannelHandler {
        private Object owner;

        public ChannelHandler(Player player) {
            this.owner = player;
        }

        public ChannelHandler(ChannelWrapper channelWrapper) {
            this.owner = channelWrapper;
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Cancellable cancellable = new Cancellable();
            Object pckt = msg;
            if (ChannelAbstract.Packet.isAssignableFrom(msg.getClass())) {
                pckt = NMUChannel.this.onPacketSend(this.owner, msg, cancellable);
            }
            if (cancellable.isCancelled()) {
                return;
            }
            super.write(ctx, pckt, promise);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Cancellable cancellable = new Cancellable();
            Object pckt = msg;
            if (ChannelAbstract.Packet.isAssignableFrom(msg.getClass())) {
                pckt = NMUChannel.this.onPacketReceive(this.owner, msg, cancellable);
            }
            if (cancellable.isCancelled()) {
                return;
            }
            super.channelRead(ctx, pckt);
        }

        public String toString() {
            return "NMUChannel$ChannelHandler@" + this.hashCode() + " (" + this.owner + ")";
        }
    }

    class ListenerList<E>
    extends ArrayList<E>
    implements ChannelAbstract.IListenerList<E> {
        ListenerList() {
        }

        @Override
        public boolean add(E paramE) {
            try {
                final E a = paramE;
                NMUChannel.this.addChannelExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Channel channel = null;
                            while (channel == null) {
                                channel = (Channel)channelField.get(a);
                            }
                            if (channel.pipeline().get("packet_listener_server") == null) {
                                channel.pipeline().addBefore("packet_handler", "packet_listener_server", (net.minecraft.util.io.netty.channel.ChannelHandler)new ChannelHandler(new NMUChannelWrapper(channel)));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.add(paramE);
        }

        @Override
        public boolean remove(Object arg0) {
            try {
                final Object a = arg0;
                NMUChannel.this.removeChannelExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Channel channel = null;
                            while (channel == null) {
                                channel = (Channel)channelField.get(a);
                            }
                            channel.pipeline().remove("packet_listener_server");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.remove(arg0);
        }
    }
}

