/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.packetlistener;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.inventivetalent.packetlistener.IPacketListener;
import org.inventivetalent.packetlistener.channel.ChannelAbstract;
import org.inventivetalent.packetlistener.reflection.resolver.ClassResolver;
import org.inventivetalent.packetlistener.reflection.resolver.ConstructorResolver;

public class ChannelInjector {
    private static final ClassResolver CLASS_RESOLVER = new ClassResolver();
    private ChannelAbstract channel;

    public boolean inject(IPacketListener iPacketListener) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            Class.forName("net.minecraft.util.io.netty.channel.Channel");
            this.channel = this.newChannelInstance(iPacketListener, "org.inventivetalent.packetlistener.channel.NMUChannel");
            System.out.println("[PacketListenerAPI] Using NMUChannel");
            return true;
        }
        catch (Exception e) {
            exceptions.add(e);
            try {
                Class.forName("io.netty.channel.Channel");
                this.channel = this.newChannelInstance(iPacketListener, "org.inventivetalent.packetlistener.channel.INCChannel");
                System.out.println("[PacketListenerAPI] Using INChannel");
                return true;
            }
            catch (Exception e1) {
                exceptions.add(e1);
                for (Exception e2 : exceptions) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
    }

    protected ChannelAbstract newChannelInstance(IPacketListener iPacketListener, String clazzName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return (ChannelAbstract)new ConstructorResolver(CLASS_RESOLVER.resolve(clazzName)).resolve(new Class[][]{{IPacketListener.class}}).newInstance(iPacketListener);
    }

    public void addChannel(Player p) {
        this.channel.addChannel(p);
    }

    public void removeChannel(Player p) {
        this.channel.removeChannel(p);
    }

    public void addServerChannel() {
        this.channel.addServerChannel();
    }
}

