/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.update;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.update.Version;

public class UpdateUtil {
    public static final String PREFIX = ChatColor.GREEN + "" + ChatColor.BOLD + "[ViaVersion] " + ChatColor.GREEN;
    private static final String URL = "http://api.spiget.org/v2/resources/";
    private static final int PLUGIN = 19254;
    private static final String LATEST_VERSION = "/versions/latest";

    public static void sendUpdateMessage(final UUID uuid, final Plugin plugin) {
        new BukkitRunnable(){

            public void run() {
                final String message = UpdateUtil.getUpdateMessage(false);
                if (message != null) {
                    new BukkitRunnable(){

                        public void run() {
                            Player p = Bukkit.getPlayer((UUID)uuid);
                            if (p != null) {
                                p.sendMessage(PREFIX + message);
                            }
                        }
                    }.runTask(plugin);
                }
            }
        }.runTaskAsynchronously(plugin);
    }

    public static void sendUpdateMessage(final Plugin plugin) {
        new BukkitRunnable(){

            public void run() {
                final String message = UpdateUtil.getUpdateMessage(true);
                if (message != null) {
                    new BukkitRunnable(){

                        public void run() {
                            plugin.getLogger().warning(message);
                        }
                    }.runTask(plugin);
                }
            }
        }.runTaskAsynchronously(plugin);
    }

    private static String getUpdateMessage(boolean console) {
        Version current;
        if (ViaVersion.getInstance().getVersion().equals("${project.version}")) {
            return "You are using a debug/custom version, consider updating.";
        }
        String newestString = UpdateUtil.getNewestVersion();
        if (newestString == null) {
            if (console) {
                return "Could not check for updates, check your connection.";
            }
            return null;
        }
        try {
            current = new Version(ViaVersion.getInstance().getVersion());
        }
        catch (IllegalArgumentException e) {
            return "You are using a custom version, consider updating.";
        }
        Version newest = new Version(newestString);
        if (current.compareTo(newest) < 0) {
            return "There is a newer version available: " + newest.toString() + ", you're on: " + current.toString();
        }
        if (console && current.compareTo(newest) != 0) {
            if (current.getTag().toLowerCase().startsWith("dev") || current.getTag().toLowerCase().startsWith("snapshot")) {
                return "You are running a development version, please report any bugs to GitHub.";
            }
            return "You are running a newer version than is released!";
        }
        return null;
    }

    private static String getNewestVersion() {
        try {
            JSONObject statistics;
            String input;
            URL url = new URL("http://api.spiget.org/v2/resources/19254/versions/latest?" + System.currentTimeMillis());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(true);
            connection.addRequestProperty("User-Agent", "ViaVersion " + ViaVersion.getInstance().getVersion());
            connection.setDoOutput(true);
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String content = "";
            while ((input = br.readLine()) != null) {
                content = content + input;
            }
            br.close();
            JSONParser parser = new JSONParser();
            try {
                statistics = (JSONObject)parser.parse(content);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
            return (String)statistics.get((Object)"name");
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

