/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.packets;

import org.bukkit.Material;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.minecraft.item.Item;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.remapper.ValueCreator;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.ItemRewriter;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9TO1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.chunks.Chunk1_9to1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.sounds.Effect;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.sounds.SoundEffect;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.ClientChunks;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.EntityTracker;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.storage.PlaceBlockTracker;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.types.ChunkType;
import us.myles.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import us.myles.viaversion.libs.opennbt.tag.builtin.StringTag;
import us.myles.viaversion.libs.opennbt.tag.builtin.Tag;

public class WorldPackets {
    public static void register(Protocol protocol) {
        protocol.registerOutgoing(State.PLAY, 51, 70, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
            }
        });
        protocol.registerOutgoing(State.PLAY, 40, 33, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.INT);
                this.map(Type.POSITION);
                this.map(Type.INT);
                this.map(Type.BOOLEAN);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int id = wrapper.get(Type.INT, 0);
                        id = Effect.getNewId(id);
                        wrapper.set(Type.INT, 0, id);
                    }
                });
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int id = wrapper.get(Type.INT, 0);
                        if (id == 2002) {
                            int data = wrapper.get(Type.INT, 1);
                            int newData = ItemRewriter.getNewEffectID(data);
                            wrapper.set(Type.INT, 1, newData);
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 41, 25, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        String name = wrapper.get(Type.STRING, 0);
                        SoundEffect effect = SoundEffect.getByName(name);
                        int catid = 0;
                        String newname = name;
                        if (effect != null) {
                            catid = effect.getCategory().getId();
                            newname = effect.getNewName();
                        }
                        wrapper.set(Type.STRING, 0, newname);
                        wrapper.write(Type.VAR_INT, catid);
                        if (effect != null && effect.isBreaksound()) {
                            EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                            int x = wrapper.passthrough(Type.INT);
                            int y = wrapper.passthrough(Type.INT);
                            int z = wrapper.passthrough(Type.INT);
                            if (tracker.interactedBlockRecently((int)Math.floor((double)x / 8.0), (int)Math.floor((double)y / 8.0), (int)Math.floor((double)z / 8.0))) {
                                wrapper.cancel();
                                return;
                            }
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 33, 32, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ClientChunks clientChunks = wrapper.user().get(ClientChunks.class);
                        Chunk1_9to1_8 chunk = (Chunk1_9to1_8)wrapper.passthrough(new ChunkType(clientChunks));
                        if (chunk.isUnloadPacket()) {
                            wrapper.setId(29);
                        }
                        wrapper.read(Type.REMAINING_BYTES);
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 53, 9, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.NBT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        CompoundTag tag;
                        short action = wrapper.get(Type.UNSIGNED_BYTE, 0);
                        if (action == 1 && (tag = wrapper.get(Type.NBT, 0)) != null) {
                            if (tag.contains("EntityId")) {
                                String entity = (String)((Tag)tag.get("EntityId")).getValue();
                                CompoundTag spawn = new CompoundTag("SpawnData");
                                spawn.put(new StringTag("id", entity));
                                tag.put(spawn);
                            } else {
                                CompoundTag spawn = new CompoundTag("SpawnData");
                                spawn.put(new StringTag("id", "AreaEffectCloud"));
                                tag.put(spawn);
                            }
                        }
                        if (action == 2) {
                            wrapper.cancel();
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 65, 13, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        if (ViaVersion.getConfig().isAutoTeam()) {
                            EntityTracker entityTracker = wrapper.user().get(EntityTracker.class);
                            entityTracker.setAutoTeam(true);
                            entityTracker.sendTeamPacket(true);
                        }
                    }
                });
            }
        });
        protocol.registerOutgoing(State.PLAY, 35, 11, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.VAR_INT);
            }
        });
        protocol.registerOutgoing(State.PLAY, 37, 8);
        protocol.registerOutgoing(State.PLAY, 36, 10);
        protocol.registerOutgoing(State.PLAY, 34, 16);
        protocol.registerOutgoing(State.PLAY, 39, 28);
        protocol.registerOutgoing(State.PLAY, 42, 34);
        protocol.registerOutgoing(State.PLAY, 3, 68);
        protocol.registerOutgoing(State.PLAY, 68, 53);
        protocol.registerIncoming(State.PLAY, 18, 25, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
                this.map(Type.STRING, Protocol1_9TO1_8.FIX_JSON);
            }
        });
        protocol.registerIncoming(State.PLAY, 7, 19, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.POSITION);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        short status = wrapper.get(Type.UNSIGNED_BYTE, 0);
                        if (status == 6) {
                            wrapper.cancel();
                        }
                    }
                });
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        EntityTracker entityTracker;
                        short status = wrapper.get(Type.UNSIGNED_BYTE, 0);
                        if ((status == 5 || status == 4 || status == 3) && (entityTracker = wrapper.user().get(EntityTracker.class)).isBlocking()) {
                            entityTracker.setBlocking(false);
                            entityTracker.setSecondHand(null);
                        }
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, -1, 29, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int hand = wrapper.read(Type.VAR_INT);
                        wrapper.clearInputBuffer();
                        wrapper.setId(8);
                        wrapper.write(Type.LONG, -1L);
                        wrapper.write(Type.BYTE, (byte)-1);
                        Item item = Protocol1_9TO1_8.getHandItem(wrapper.user());
                        if (ViaVersion.getConfig().isShieldBlocking() && item != null && Material.getMaterial((int)item.getId()) != null && Material.getMaterial((int)item.getId()).name().endsWith("SWORD") && hand == 0) {
                            EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                            if (!tracker.isBlocking()) {
                                tracker.setBlocking(true);
                                Item shield = new Item(442, 1, 0, null);
                                tracker.setSecondHand(shield);
                            }
                            wrapper.cancel();
                        }
                        wrapper.write(Type.ITEM, item);
                        wrapper.write(Type.BYTE, (byte)0);
                        wrapper.write(Type.BYTE, (byte)0);
                        wrapper.write(Type.BYTE, (byte)0);
                    }
                });
            }
        });
        protocol.registerIncoming(State.PLAY, 8, 28, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.POSITION);
                this.map(Type.VAR_INT, Type.BYTE);
                this.map(Type.VAR_INT, Type.NOTHING);
                this.create(new ValueCreator(){

                    @Override
                    public void write(PacketWrapper wrapper) throws Exception {
                        Item item = Protocol1_9TO1_8.getHandItem(wrapper.user());
                        wrapper.write(Type.ITEM, item);
                    }
                });
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.map(Type.UNSIGNED_BYTE);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        Position position = wrapper.get(Type.POSITION, 0);
                        PlaceBlockTracker tracker = wrapper.user().get(PlaceBlockTracker.class);
                        if (tracker.getLastPlacedPosition() != null && tracker.getLastPlacedPosition().equals(position) && !tracker.isExpired(50)) {
                            wrapper.cancel();
                        }
                        tracker.updateTime();
                        tracker.setLastPlacedPosition(position);
                    }
                });
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        byte face = wrapper.get(Type.BYTE, 0);
                        if (face == 255) {
                            return;
                        }
                        Position p = wrapper.get(Type.POSITION, 0);
                        long x = p.getX();
                        long y = p.getY();
                        long z = p.getZ();
                        switch (face) {
                            case 0: {
                                --y;
                                break;
                            }
                            case 1: {
                                ++y;
                                break;
                            }
                            case 2: {
                                --z;
                                break;
                            }
                            case 3: {
                                ++z;
                                break;
                            }
                            case 4: {
                                --x;
                                break;
                            }
                            case 5: {
                                ++x;
                            }
                        }
                        EntityTracker tracker = wrapper.user().get(EntityTracker.class);
                        tracker.addBlockInteraction(new Position(x, y, z));
                    }
                });
            }
        });
    }
}

