/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.ViaListener;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9TO1_8;

public class DeathListener
extends ViaListener {
    public DeathListener(ViaVersionPlugin plugin) {
        super(plugin, Protocol1_9TO1_8.class);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (this.isOnPipe(p) && ViaVersion.getConfig().isShowNewDeathMessages() && this.checkGamerule(p.getWorld()) && e.getDeathMessage() != null) {
            this.sendPacket(p, e.getDeathMessage());
        }
    }

    public boolean checkGamerule(World w) {
        try {
            return Boolean.parseBoolean(w.getGameRuleValue("showDeathMessages"));
        }
        catch (Exception e) {
            return false;
        }
    }

    private void sendPacket(final Player p, final String msg) {
        Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), new Runnable(){

            @Override
            public void run() {
                PacketWrapper wrapper = new PacketWrapper(44, null, DeathListener.this.getUserConnection(p));
                try {
                    wrapper.write(Type.VAR_INT, 2);
                    wrapper.write(Type.VAR_INT, p.getEntityId());
                    wrapper.write(Type.INT, p.getEntityId());
                    Protocol1_9TO1_8.FIX_JSON.write(wrapper, msg);
                    wrapper.send(Protocol1_9TO1_8.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

