/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.listeners;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.CommandBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.ViaListener;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.minecraft.Position;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9TO1_8;
import us.myles.ViaVersion.util.ReflectionUtil;
import us.myles.viaversion.libs.opennbt.tag.builtin.ByteTag;
import us.myles.viaversion.libs.opennbt.tag.builtin.CompoundTag;

public class CommandBlockListener
extends ViaListener {
    public CommandBlockListener(ViaVersionPlugin plugin) {
        super(plugin, Protocol1_9TO1_8.class);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent e) {
        this.sendOp(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(final PlayerRespawnEvent e) {
        if (!this.isOnPipe(e.getPlayer())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), new Runnable(){

            @Override
            public void run() {
                CommandBlockListener.this.sendOp(e.getPlayer());
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.sendOp(e.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && this.isOnPipe(e.getPlayer()) && e.getPlayer().isOp()) {
            try {
                this.sendCommandBlockPacket(e.getClickedBlock(), e.getPlayer());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void sendOp(Player p) {
        if (p.isOp() && this.isOnPipe(p)) {
            try {
                PacketWrapper wrapper = new PacketWrapper(27, null, this.getUserConnection(p));
                wrapper.write(Type.INT, p.getEntityId());
                wrapper.write(Type.BYTE, (byte)26);
                wrapper.send(Protocol1_9TO1_8.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sendCommandBlockPacket(Block b, Player player) throws Exception {
        if (!(b.getState() instanceof CommandBlock)) {
            return;
        }
        CommandBlock cmd = (CommandBlock)b.getState();
        Object tileEntityCommand = ReflectionUtil.get(cmd, "commandBlock", ReflectionUtil.nms("TileEntityCommand"));
        Object updatePacket = ReflectionUtil.invoke(tileEntityCommand, "getUpdatePacket");
        PacketWrapper wrapper = this.generatePacket(updatePacket, this.getUserConnection(player));
        wrapper.send(Protocol1_9TO1_8.class);
    }

    private PacketWrapper generatePacket(Object updatePacket, UserConnection usr) throws Exception {
        PacketWrapper wrapper = new PacketWrapper(9, null, usr);
        long[] pos = this.getPosition(ReflectionUtil.get(updatePacket, "a", ReflectionUtil.nms("BlockPosition")));
        wrapper.write(Type.POSITION, new Position(pos[0], pos[1], pos[2]));
        wrapper.write(Type.BYTE, (byte)2);
        CompoundTag nbt = this.getNBT(ReflectionUtil.get(updatePacket, "c", ReflectionUtil.nms("NBTTagCompound")));
        if (nbt == null) {
            wrapper.write(Type.BYTE, (byte)0);
            return wrapper;
        }
        nbt.put(new ByteTag("powered", 0));
        nbt.put(new ByteTag("auto", 0));
        nbt.put(new ByteTag("conditionMet", 0));
        wrapper.write(Type.NBT, nbt);
        return wrapper;
    }

    private long[] getPosition(Object obj) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return new long[]{ReflectionUtil.getSuper(obj, "a", Integer.TYPE).intValue(), ReflectionUtil.getSuper(obj, this.isR1() ? "b" : "c", Integer.TYPE).intValue(), ReflectionUtil.getSuper(obj, this.isR1() ? "c" : "d", Integer.TYPE).intValue()};
    }

    private boolean isR1() {
        return ReflectionUtil.getVersion().equals("v1_8_R1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompoundTag getNBT(Object obj) throws Exception {
        ByteBuf buf = Unpooled.buffer();
        Method m = ReflectionUtil.nms("NBTCompressedStreamTools").getMethod("a", ReflectionUtil.nms("NBTTagCompound"), DataOutput.class);
        m.invoke(null, obj, new DataOutputStream((OutputStream)new ByteBufOutputStream(buf)));
        try {
            CompoundTag compoundTag = (CompoundTag)Type.NBT.read(buf);
            return compoundTag;
        }
        finally {
            buf.release();
        }
    }
}

