/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9to1_8.chunks;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import us.myles.ViaVersion.api.minecraft.chunks.ChunkSection;
import us.myles.ViaVersion.api.minecraft.chunks.NibbleArray;
import us.myles.ViaVersion.api.type.Type;

public class ChunkSection1_9to1_8
implements ChunkSection {
    public static final int SIZE = 4096;
    public static final int LIGHT_LENGTH = 2048;
    private final List<Integer> palette = Lists.newArrayList();
    private final int[] blocks = new int[4096];
    private final NibbleArray blockLight = new NibbleArray(4096);
    private NibbleArray skyLight;

    public ChunkSection1_9to1_8() {
        this.palette.add(0);
    }

    public void setBlock(int x, int y, int z, int type, int data) {
        this.setBlock(this.index(x, y, z), type, data);
    }

    @Override
    public int getBlockId(int x, int y, int z) {
        int index = this.blocks[this.index(x, y, z)];
        return this.palette.get(index) >> 4;
    }

    public void setBlock(int idx, int type, int data) {
        int hash = type << 4 | data & 0xF;
        int index = this.palette.indexOf(hash);
        if (index == -1) {
            index = this.palette.size();
            this.palette.add(hash);
        }
        this.blocks[idx] = index;
    }

    public void setBlockLight(byte[] data) {
        this.blockLight.setHandle(data);
    }

    public void setSkyLight(byte[] data) {
        if (data.length != 2048) {
            throw new IllegalArgumentException("Data length != 2048");
        }
        this.skyLight = new NibbleArray(data);
    }

    private int index(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    @Override
    public void writeBlocks(ByteBuf output) throws Exception {
        int bitsPerBlock = 4;
        while (this.palette.size() > 1 << bitsPerBlock) {
            ++bitsPerBlock;
        }
        long maxEntryValue = (1L << bitsPerBlock) - 1L;
        output.writeByte(bitsPerBlock);
        Type.VAR_INT.write(output, this.palette.size());
        for (int mappedId : this.palette) {
            Type.VAR_INT.write(output, mappedId);
        }
        int length = (int)Math.ceil((double)(4096 * bitsPerBlock) / 64.0);
        Type.VAR_INT.write(output, length);
        long[] data = new long[length];
        for (int index = 0; index < this.blocks.length; ++index) {
            int value = this.blocks[index];
            int bitIndex = index * bitsPerBlock;
            int startIndex = bitIndex / 64;
            int endIndex = ((index + 1) * bitsPerBlock - 1) / 64;
            int startBitSubIndex = bitIndex % 64;
            data[startIndex] = data[startIndex] & (maxEntryValue << startBitSubIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & maxEntryValue) << startBitSubIndex;
            if (startIndex == endIndex) continue;
            int endBitSubIndex = 64 - startBitSubIndex;
            data[endIndex] = data[endIndex] >>> endBitSubIndex << endBitSubIndex | ((long)value & maxEntryValue) >> endBitSubIndex;
        }
        for (long l : data) {
            Type.LONG.write(output, l);
        }
    }

    @Override
    public void writeBlockLight(ByteBuf output) {
        output.writeBytes(this.blockLight.getHandle());
    }

    @Override
    public void writeSkyLight(ByteBuf output) {
        output.writeBytes(this.skyLight.getHandle());
    }

    @Override
    public boolean hasSkyLight() {
        return this.skyLight != null;
    }

    public int getExpectedSize() throws Exception {
        int bitsPerBlock = this.palette.size() > 255 ? 16 : 8;
        int bytes = 1;
        bytes += this.paletteBytes();
        bytes += this.countBytes(bitsPerBlock == 16 ? 8192 : 4096);
        bytes += (this.palette.size() > 255 ? 2 : 1) * 4096;
        bytes += 2048;
        return bytes += this.hasSkyLight() ? 2048 : 0;
    }

    private int paletteBytes() throws Exception {
        int bytes = this.countBytes(this.palette.size());
        for (int mappedId : this.palette) {
            bytes += this.countBytes(mappedId);
        }
        return bytes;
    }

    private int countBytes(int value) throws Exception {
        ByteBuf buf = Unpooled.buffer();
        Type.VAR_INT.write(buf, value);
        buf.readerIndex(0);
        int bitCount = buf.readableBytes();
        buf.release();
        return bitCount;
    }
}

