/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.protocol1_9_1_2to1_9_3_4.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.bukkit.World;
import us.myles.ViaVersion.api.minecraft.chunks.Chunk;
import us.myles.ViaVersion.api.minecraft.chunks.ChunkSection;
import us.myles.ViaVersion.api.type.PartialType;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.api.type.types.minecraft.BaseChunkType;
import us.myles.ViaVersion.protocols.protocol1_9_1_2to1_9_3_4.chunks.Chunk1_9_3_4;
import us.myles.ViaVersion.protocols.protocol1_9_1_2to1_9_3_4.chunks.ChunkSection1_9_3_4;
import us.myles.ViaVersion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;

public class Chunk1_9_3_4Type
extends PartialType<Chunk, ClientWorld> {
    public Chunk1_9_3_4Type(ClientWorld param) {
        super(param, Chunk.class);
    }

    @Override
    public Chunk read(ByteBuf input, ClientWorld world) throws Exception {
        byte[] biomeData;
        int i;
        int chunkX = input.readInt();
        int chunkZ = input.readInt();
        boolean groundUp = input.readBoolean();
        int primaryBitmask = (Integer)Type.VAR_INT.read(input);
        Type.VAR_INT.read(input);
        BitSet usedSections = new BitSet(16);
        ChunkSection1_9_3_4[] sections = new ChunkSection1_9_3_4[16];
        for (i = 0; i < 16; ++i) {
            if ((primaryBitmask & 1 << i) == 0) continue;
            usedSections.set(i);
        }
        for (i = 0; i < 16; ++i) {
            ChunkSection1_9_3_4 section;
            if (!usedSections.get(i)) continue;
            sections[i] = section = new ChunkSection1_9_3_4();
            section.readBlocks(input);
            section.readBlockLight(input);
            if (world.getEnvironment() != World.Environment.NORMAL) continue;
            section.readSkyLight(input);
        }
        byte[] byArray = biomeData = groundUp ? new byte[256] : null;
        if (groundUp) {
            input.readBytes(biomeData);
        }
        List<Object> nbtData = Arrays.asList((Object[])Type.NBT_ARRAY.read(input));
        return new Chunk1_9_3_4(chunkX, chunkZ, groundUp, primaryBitmask, sections, biomeData, nbtData);
    }

    @Override
    public void write(ByteBuf output, ClientWorld world, Chunk chunk) throws Exception {
        output.writeInt(chunk.getX());
        output.writeInt(chunk.getZ());
        output.writeBoolean(chunk.isGroundUp());
        Type.VAR_INT.write(output, chunk.getBitmask());
        ByteBuf buf = Unpooled.buffer();
        for (int i = 0; i < 16; ++i) {
            ChunkSection section = chunk.getSections()[i];
            if (section == null) continue;
            section.writeBlocks(buf);
            section.writeBlockLight(buf);
            if (!section.hasSkyLight()) continue;
            section.writeSkyLight(buf);
        }
        buf.readerIndex(0);
        Type.VAR_INT.write(output, buf.readableBytes() + (chunk.isBiomeData() ? 256 : 0));
        output.writeBytes(buf);
        buf.release();
        if (chunk.isBiomeData()) {
            output.writeBytes(chunk.getBiomeData());
        }
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkType.class;
    }
}

