/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.protocols.base;

import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.protocol.ProtocolPipeline;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.api.remapper.PacketHandler;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.Direction;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9TO1_8;

public class BaseProtocol
extends Protocol {
    @Override
    protected void registerPackets() {
        this.registerOutgoing(State.STATUS, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ProtocolInfo info = wrapper.user().get(ProtocolInfo.class);
                        String originalStatus = wrapper.get(Type.STRING, 0);
                        try {
                            List<Pair<Integer, Protocol>> protocols;
                            JSONObject json = (JSONObject)new JSONParser().parse(originalStatus);
                            JSONObject version = (JSONObject)json.get((Object)"version");
                            int protocolVersion = ((Long)version.get((Object)"protocol")).intValue();
                            if (ViaVersion.getConfig().isSendSupportedVersions()) {
                                version.put((Object)"supportedVersions", ViaVersion.getInstance().getSupportedVersions());
                            }
                            if (ProtocolRegistry.SERVER_PROTOCOL == -1) {
                                ProtocolRegistry.SERVER_PROTOCOL = protocolVersion;
                            }
                            if ((protocols = ProtocolRegistry.getProtocolPath(info.getProtocolVersion(), ProtocolRegistry.SERVER_PROTOCOL)) != null) {
                                if (protocolVersion != 9999) {
                                    version.put((Object)"protocol", (Object)info.getProtocolVersion());
                                }
                            } else {
                                wrapper.user().setActive(false);
                            }
                            if (ViaVersion.getConfig().getBlockedProtocols().contains(info.getProtocolVersion())) {
                                version.put((Object)"protocol", (Object)-1);
                            }
                            wrapper.set(Type.STRING, 0, json.toJSONString());
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.STATUS, 1, 1);
        this.registerOutgoing(State.LOGIN, 0, 0);
        this.registerOutgoing(State.LOGIN, 1, 1);
        this.registerOutgoing(State.LOGIN, 2, 2, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.STRING);
                this.map(Type.STRING);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        ProtocolInfo info = wrapper.user().get(ProtocolInfo.class);
                        info.setState(State.PLAY);
                        UUID uuid = UUID.fromString(wrapper.get(Type.STRING, 0));
                        info.setUuid(uuid);
                        info.setUsername(wrapper.get(Type.STRING, 1));
                        ((ViaVersionPlugin)ViaVersion.getInstance()).addPortedClient(wrapper.user());
                        if (info.getPipeline().pipes().size() == 1 && info.getPipeline().pipes().get(0).getClass() == BaseProtocol.class) {
                            wrapper.user().setActive(false);
                        }
                        if (ViaVersion.getInstance().isDebug()) {
                            ((ViaVersionPlugin)ViaVersion.getInstance()).getLogger().log(Level.INFO, "{0} logged in with protocol {1}, Route: {2}", new Object[]{wrapper.get(Type.STRING, 1), info.getProtocolVersion(), StringUtils.join(info.getPipeline().pipes(), (String)", ")});
                        }
                    }
                });
            }
        });
        this.registerOutgoing(State.LOGIN, 3, 3);
        this.registerIncoming(State.HANDSHAKE, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.map(Type.VAR_INT);
                this.map(Type.STRING);
                this.map(Type.UNSIGNED_SHORT);
                this.map(Type.VAR_INT);
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(PacketWrapper wrapper) throws Exception {
                        int protVer = wrapper.get(Type.VAR_INT, 0);
                        int state = wrapper.get(Type.VAR_INT, 1);
                        ProtocolInfo info = wrapper.user().get(ProtocolInfo.class);
                        info.setProtocolVersion(protVer);
                        List<Pair<Integer, Protocol>> protocols = ProtocolRegistry.getProtocolPath(info.getProtocolVersion(), ProtocolRegistry.SERVER_PROTOCOL);
                        ProtocolPipeline pipeline = wrapper.user().get(ProtocolInfo.class).getPipeline();
                        if (protocols != null) {
                            for (Pair<Integer, Protocol> prot : protocols) {
                                pipeline.add(prot.getValue());
                            }
                            wrapper.set(Type.VAR_INT, 0, ProtocolRegistry.SERVER_PROTOCOL);
                        }
                        if (state == 1) {
                            info.setState(State.STATUS);
                        }
                        if (state == 2) {
                            info.setState(State.LOGIN);
                        }
                    }
                });
            }
        });
        this.registerIncoming(State.STATUS, 0, 0);
        this.registerIncoming(State.STATUS, 1, 1);
        this.registerIncoming(State.LOGIN, 0, 0, new PacketRemapper(){

            @Override
            public void registerMap() {
                this.handler(new PacketHandler(){

                    @Override
                    public void handle(final PacketWrapper wrapper) throws Exception {
                        int protocol = wrapper.user().get(ProtocolInfo.class).getProtocolVersion();
                        if (ViaVersion.getConfig().getBlockedProtocols().contains(protocol)) {
                            if (!wrapper.user().getChannel().isOpen()) {
                                return;
                            }
                            PacketWrapper disconnectPacket = new PacketWrapper(0, null, wrapper.user());
                            Protocol1_9TO1_8.FIX_JSON.write(disconnectPacket, ChatColor.translateAlternateColorCodes((char)'&', (String)ViaVersion.getConfig().getBlockedDisconnectMsg()));
                            wrapper.cancel();
                            ChannelFuture future = disconnectPacket.sendFuture(BaseProtocol.class);
                            future.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                                public void operationComplete(Future<? super Void> future) throws Exception {
                                    wrapper.user().getChannel().close();
                                }
                            });
                        }
                    }
                });
            }
        });
        this.registerIncoming(State.LOGIN, 1, 1);
    }

    @Override
    public void init(UserConnection userConnection) {
    }

    @Override
    protected void registerListeners() {
        final ViaVersionPlugin plugin = (ViaVersionPlugin)Bukkit.getPluginManager().getPlugin("ViaVersion");
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onPlayerQuit(PlayerQuitEvent e) {
                plugin.removePortedClient(e.getPlayer().getUniqueId());
            }
        }, (Plugin)plugin);
    }

    @Override
    public void transform(Direction direction, State state, PacketWrapper packetWrapper) throws Exception {
        super.transform(direction, state, packetWrapper);
        if (direction == Direction.INCOMING && state == State.HANDSHAKE && packetWrapper.getId() > 0) {
            packetWrapper.user().setActive(false);
        }
    }
}

