/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.exception.CancelException;
import us.myles.ViaVersion.packets.Direction;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.util.PipelineUtil;

public class ViaEncodeHandler
extends MessageToByteEncoder {
    private final UserConnection info;
    private final MessageToByteEncoder minecraftEncoder;

    public ViaEncodeHandler(UserConnection info, MessageToByteEncoder minecraftEncoder) {
        this.info = info;
        this.minecraftEncoder = minecraftEncoder;
    }

    protected void encode(ChannelHandlerContext ctx, Object o, ByteBuf bytebuf) throws Exception {
        block11: {
            if (ViaVersion.getInstance().isCompatSpigotBuild()) {
                Field ver = this.minecraftEncoder.getClass().getDeclaredField("version");
                ver.setAccessible(true);
                ver.set(this.minecraftEncoder, ver.get((Object)this));
            }
            if (!(o instanceof ByteBuf)) {
                try {
                    PipelineUtil.callEncode(this.minecraftEncoder, ctx, o, bytebuf);
                }
                catch (InvocationTargetException e) {
                    if (!(e.getCause() instanceof Exception)) break block11;
                    throw (Exception)e.getCause();
                }
            }
        }
        if (bytebuf.readableBytes() == 0) {
            throw new CancelException();
        }
        this.info.incrementSent();
        if (this.info.isActive()) {
            int id = (Integer)Type.VAR_INT.read(bytebuf);
            ByteBuf oldPacket = bytebuf.copy();
            bytebuf.clear();
            try {
                PacketWrapper wrapper = new PacketWrapper(id, oldPacket, this.info);
                ProtocolInfo protInfo = this.info.get(ProtocolInfo.class);
                protInfo.getPipeline().transform(Direction.OUTGOING, protInfo.getState(), wrapper);
                wrapper.writeToBuffer(bytebuf);
            }
            catch (Exception e) {
                bytebuf.clear();
                throw e;
            }
            finally {
                oldPacket.release();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (PipelineUtil.containsCause(cause, CancelException.class)) {
            return;
        }
        super.exceptionCaught(ctx, cause);
    }
}

