/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.exception.CancelException;
import us.myles.ViaVersion.packets.Direction;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.util.PipelineUtil;

public class ViaDecodeHandler
extends ByteToMessageDecoder {
    private final ByteToMessageDecoder minecraftDecoder;
    private final UserConnection info;
    public static int PASSTHROUGH_ID = 1000;

    public ViaDecodeHandler(UserConnection info, ByteToMessageDecoder minecraftDecoder) {
        this.info = info;
        this.minecraftDecoder = minecraftDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf bytebuf, List<Object> list) throws Exception {
        if (bytebuf.readableBytes() > 0) {
            if (this.info.isPendingDisconnect()) {
                return;
            }
            boolean second = this.info.incrementReceived();
            if (second && ((ViaVersionPlugin)ViaVersion.getInstance()).handlePPS(this.info)) {
                return;
            }
            if (this.info.isActive()) {
                int id = (Integer)Type.VAR_INT.read(bytebuf);
                ByteBuf newPacket = ctx.alloc().buffer();
                try {
                    if (id == PASSTHROUGH_ID) {
                        newPacket.writeBytes(bytebuf);
                    } else {
                        PacketWrapper wrapper = new PacketWrapper(id, bytebuf, this.info);
                        ProtocolInfo protInfo = this.info.get(ProtocolInfo.class);
                        protInfo.getPipeline().transform(Direction.INCOMING, protInfo.getState(), wrapper);
                        wrapper.writeToBuffer(newPacket);
                    }
                    bytebuf.clear();
                    bytebuf = newPacket;
                }
                catch (Exception e) {
                    bytebuf.clear();
                    newPacket.release();
                    throw e;
                }
            }
            try {
                list.addAll(PipelineUtil.callDecode(this.minecraftDecoder, ctx, bytebuf));
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
            }
            finally {
                if (this.info.isActive()) {
                    bytebuf.release();
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (PipelineUtil.containsCause(cause, CancelException.class)) {
            return;
        }
        super.exceptionCaught(ctx, cause);
    }
}

