/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.commands.defaultsubs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.command.ViaSubCommand;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;

public class PPSSubCmd
extends ViaSubCommand {
    @Override
    public String name() {
        return "pps";
    }

    @Override
    public String description() {
        return "Shows the packets per second of online players";
    }

    @Override
    public String usage() {
        return "pps";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        HashMap playerVersions = new HashMap();
        int totalPackets = 0;
        int clients = 0;
        long max = 0L;
        for (Player p : Bukkit.getOnlinePlayers()) {
            UserConnection uc;
            if (!ViaVersion.getInstance().isPorted(p)) continue;
            int playerVersion = ViaVersion.getInstance().getPlayerVersion(p);
            if (!playerVersions.containsKey(playerVersion)) {
                playerVersions.put(playerVersion, new HashSet());
            }
            if ((uc = ((ViaVersionPlugin)ViaVersion.getInstance()).getConnection(p)).getPacketsPerSecond() <= -1L) continue;
            ((Set)playerVersions.get(playerVersion)).add(p.getName() + " (" + uc.getPacketsPerSecond() + " PPS)");
            totalPackets = (int)((long)totalPackets + uc.getPacketsPerSecond());
            if (uc.getPacketsPerSecond() > max) {
                max = uc.getPacketsPerSecond();
            }
            ++clients;
        }
        TreeMap sorted = new TreeMap(playerVersions);
        this.sendMessage(sender, "&4Live Packets Per Second", new Object[0]);
        if (clients > 1) {
            this.sendMessage(sender, "&cAverage: &f" + totalPackets / clients, new Object[0]);
            this.sendMessage(sender, "&cHighest: &f" + max, new Object[0]);
        }
        if (clients == 0) {
            this.sendMessage(sender, "&cNo clients to display.", new Object[0]);
        }
        for (Map.Entry entry : sorted.entrySet()) {
            this.sendMessage(sender, "&8[&6%s&8]: &b%s", ProtocolVersion.getProtocol((Integer)entry.getKey()).getName(), entry.getValue());
        }
        sorted.clear();
        return true;
    }
}

