/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.commands.defaultsubs;

import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.command.ViaSubCommand;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.dump.DumpTemplate;
import us.myles.ViaVersion.dump.PluginInfo;
import us.myles.ViaVersion.dump.VersionInfo;
import us.myles.viaversion.libs.gson.Gson;
import us.myles.viaversion.libs.gson.GsonBuilder;
import us.myles.viaversion.libs.gson.JsonObject;

public class DumpSubCmd
extends ViaSubCommand {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public String name() {
        return "dump";
    }

    @Override
    public String description() {
        return "Dump information about your server, this is helpful if you report bugs.";
    }

    @Override
    public boolean execute(final CommandSender sender, String[] args) {
        VersionInfo version = new VersionInfo(Bukkit.getServer().getVersion(), Bukkit.getServer().getBukkitVersion(), System.getProperty("java.version"), System.getProperty("os.name"), ProtocolRegistry.SERVER_PROTOCOL, ProtocolRegistry.getSupportedVersions());
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>();
        for (Plugin p : Bukkit.getPluginManager().getPlugins()) {
            plugins.add(new PluginInfo(p.isEnabled(), p.getDescription().getName(), p.getDescription().getVersion(), p.getDescription().getMain(), p.getDescription().getAuthors()));
        }
        Map configuration = ((ViaVersionPlugin)ViaVersion.getInstance()).getConfig().getValues(false);
        final DumpTemplate template = new DumpTemplate(version, configuration, plugins);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)((ViaVersionPlugin)ViaVersion.getInstance()), new Runnable(){

            @Override
            public void run() {
                try {
                    HttpURLConnection con = (HttpURLConnection)new URL("http://hastebin.com/documents").openConnection();
                    con.setRequestProperty("Content-Type", "text/plain");
                    con.setRequestMethod("POST");
                    con.setDoOutput(true);
                    OutputStream out = con.getOutputStream();
                    out.write(DumpSubCmd.this.gson.toJson(template).getBytes(Charset.forName("UTF-8")));
                    out.close();
                    JsonObject output = DumpSubCmd.this.gson.fromJson((Reader)new InputStreamReader(con.getInputStream()), JsonObject.class);
                    con.getInputStream().close();
                    if (!output.has("key")) {
                        throw new InvalidObjectException("Key is not given in Hastebin output");
                    }
                    sender.sendMessage(ChatColor.GREEN + "We've made a dump with useful information, report your issue and provide this url: " + DumpSubCmd.this.getUrl(output.get("key").getAsString()));
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + "Failed to dump, please check the console for more information");
                    ((ViaVersionPlugin)ViaVersion.getInstance()).getLogger().log(Level.WARNING, "Could not paste ViaVersion dump to Hastebin", e);
                }
            }
        });
        return true;
    }

    private String getUrl(String id) {
        return String.format("http://hastebin.com/%s.json", id);
    }
}

