/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.command.ViaSubCommand;
import us.myles.ViaVersion.api.command.ViaVersionCommand;
import us.myles.ViaVersion.commands.defaultsubs.AutoTeamSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.DebugSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.DisplayLeaksSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.DontBugMeSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.DumpSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.HelpSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.ListSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.PPSSubCmd;
import us.myles.ViaVersion.commands.defaultsubs.ReloadSubCmd;

public class ViaCommandHandler
implements ViaVersionCommand,
CommandExecutor,
TabCompleter {
    private Map<String, ViaSubCommand> commandMap = new HashMap<String, ViaSubCommand>();

    public ViaCommandHandler() {
        try {
            this.registerDefaults();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void registerSubCommand(@NonNull ViaSubCommand command) throws Exception {
        if (command == null) {
            throw new NullPointerException("command");
        }
        Validate.isTrue((boolean)command.name().matches("^[a-z0-9_-]{3,15}$"), (String)(command.name() + " is not a valid subcommand name"));
        if (this.hasSubCommand(command.name())) {
            throw new Exception("ViaSubCommand " + command.name() + " does already exists!");
        }
        this.commandMap.put(command.name().toLowerCase(), command);
    }

    @Override
    public boolean hasSubCommand(String name) {
        return this.commandMap.containsKey(name.toLowerCase());
    }

    @Override
    public ViaSubCommand getSubCommand(String name) {
        return this.commandMap.get(name.toLowerCase());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String arg, String[] args) {
        if (args.length == 0) {
            this.showHelp(sender);
            return false;
        }
        if (!this.hasSubCommand(args[0])) {
            sender.sendMessage(ViaCommandHandler.color("&cThis command is not found"));
            this.showHelp(sender);
            return false;
        }
        ViaSubCommand handler = this.getSubCommand(args[0]);
        if (!this.hasPermission(sender, handler.permission())) {
            sender.sendMessage(ViaCommandHandler.color("&cYou are not allowed to use this command!"));
            return false;
        }
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        boolean result = handler.execute(sender, subArgs);
        if (!result) {
            sender.sendMessage("Usage: /viaversion " + handler.usage());
        }
        return result;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String arg, String[] args) {
        Set<ViaSubCommand> allowed = this.calculateAllowedCommands(sender);
        ArrayList<String> output = new ArrayList<String>();
        if (args.length == 1) {
            if (!args[0].equals("")) {
                for (ViaSubCommand sub : allowed) {
                    if (!sub.name().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    output.add(sub.name());
                }
            } else {
                for (ViaSubCommand sub : allowed) {
                    output.add(sub.name());
                }
            }
        } else if (args.length >= 2 && this.getSubCommand(args[0]) != null) {
            ViaSubCommand sub = this.getSubCommand(args[0]);
            if (!allowed.contains(sub)) {
                return output;
            }
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            List<String> tab = sub.onTabComplete(sender, subArgs);
            Collections.sort(tab);
            return tab;
        }
        return output;
    }

    public void showHelp(CommandSender sender) {
        Set<ViaSubCommand> allowed = this.calculateAllowedCommands(sender);
        if (allowed.size() == 0) {
            sender.sendMessage(ViaCommandHandler.color("&cYou are not allowed to use this command!"));
            return;
        }
        sender.sendMessage(ViaCommandHandler.color("&aViaVersion &c" + ViaVersion.getInstance().getVersion()));
        sender.sendMessage(ViaCommandHandler.color("&6Commands:"));
        for (ViaSubCommand cmd : allowed) {
            sender.sendMessage(ViaCommandHandler.color(String.format("&2/viaversion %s &7- &6%s", cmd.usage(), cmd.description())));
        }
        allowed.clear();
    }

    private Set<ViaSubCommand> calculateAllowedCommands(CommandSender sender) {
        HashSet<ViaSubCommand> cmds = new HashSet<ViaSubCommand>();
        for (ViaSubCommand sub : this.commandMap.values()) {
            if (!this.hasPermission(sender, sub.permission())) continue;
            cmds.add(sub);
        }
        return cmds;
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return permission == null || sender.hasPermission(permission);
    }

    private void registerDefaults() throws Exception {
        this.registerSubCommand(new ListSubCmd());
        this.registerSubCommand(new PPSSubCmd());
        this.registerSubCommand(new DebugSubCmd());
        this.registerSubCommand(new DumpSubCmd());
        this.registerSubCommand(new DisplayLeaksSubCmd());
        this.registerSubCommand(new DontBugMeSubCmd());
        this.registerSubCommand(new AutoTeamSubCmd());
        this.registerSubCommand(new HelpSubCmd());
        this.registerSubCommand(new ReloadSubCmd());
    }

    public static String color(String string) {
        try {
            string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void sendMessage(@NonNull CommandSender sender, String message, Object ... args) {
        if (sender == null) {
            throw new NullPointerException("sender");
        }
        sender.sendMessage(ViaCommandHandler.color(args == null ? message : String.format(message, args)));
    }
}

