/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.boss;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.boss.BossBar;
import us.myles.ViaVersion.api.boss.BossColor;
import us.myles.ViaVersion.api.boss.BossFlag;
import us.myles.ViaVersion.api.boss.BossStyle;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9TO1_8;

public class ViaBossBar
implements BossBar {
    private UUID uuid;
    private String title;
    private float health;
    private BossColor color;
    private BossStyle style;
    private Set<UUID> players;
    private boolean visible;
    private Set<BossFlag> flags;

    public ViaBossBar(String title, float health, BossColor color, BossStyle style) {
        Validate.notNull((Object)title, (String)"Title cannot be null");
        Validate.isTrue((health >= 0.0f && health <= 1.0f ? 1 : 0) != 0, (String)"Health must be between 0 and 1");
        this.uuid = UUID.randomUUID();
        this.title = title;
        this.health = health;
        this.color = color == null ? BossColor.PURPLE : color;
        this.style = style == null ? BossStyle.SOLID : style;
        this.players = new HashSet<UUID>();
        this.flags = new HashSet<BossFlag>();
        this.visible = true;
    }

    @Override
    public BossBar setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.title = title;
        this.sendPacket(UpdateAction.UPDATE_TITLE);
        return this;
    }

    @Override
    public BossBar setHealth(float health) {
        Validate.isTrue((health >= 0.0f && health <= 1.0f ? 1 : 0) != 0, (String)"Health must be between 0 and 1");
        this.health = health;
        this.sendPacket(UpdateAction.UPDATE_HEALTH);
        return this;
    }

    @Override
    public BossColor getColor() {
        return this.color;
    }

    @Override
    public BossBar setColor(@NonNull BossColor color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        this.color = color;
        this.sendPacket(UpdateAction.UPDATE_STYLE);
        return this;
    }

    @Override
    public BossBar setStyle(@NonNull BossStyle style) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        this.style = style;
        this.sendPacket(UpdateAction.UPDATE_STYLE);
        return this;
    }

    @Override
    public BossBar addPlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        return this.addPlayer(player.getUniqueId());
    }

    @Override
    public BossBar addPlayer(UUID player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            if (this.visible) {
                this.sendPacket(player, this.getPacket(UpdateAction.ADD));
            }
        }
        return this;
    }

    @Override
    public BossBar removePlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (this.players.contains(player.getUniqueId())) {
            this.players.remove(player.getUniqueId());
            this.sendPacket(player.getUniqueId(), this.getPacket(UpdateAction.REMOVE));
        }
        return this;
    }

    @Override
    public BossBar addPlayers(Player ... players) {
        if (players == null) {
            throw new NullPointerException("players");
        }
        for (Player p : players) {
            this.addPlayer(p);
        }
        return this;
    }

    @Override
    public BossBar addFlag(@NonNull BossFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag");
        }
        if (!this.hasFlag(flag)) {
            this.flags.add(flag);
        }
        this.sendPacket(UpdateAction.UPDATE_FLAGS);
        return this;
    }

    @Override
    public BossBar removeFlag(@NonNull BossFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag");
        }
        if (this.hasFlag(flag)) {
            this.flags.remove((Object)flag);
        }
        this.sendPacket(UpdateAction.UPDATE_FLAGS);
        return this;
    }

    @Override
    public boolean hasFlag(@NonNull BossFlag flag) {
        if (flag == null) {
            throw new NullPointerException("flag");
        }
        return this.flags.contains((Object)flag);
    }

    @Override
    public Set<UUID> getPlayers() {
        return Collections.unmodifiableSet(this.players);
    }

    @Override
    public BossBar show() {
        this.setVisible(true);
        return this;
    }

    @Override
    public BossBar hide() {
        this.setVisible(false);
        return this;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    private void setVisible(boolean value) {
        if (this.visible != value) {
            this.visible = value;
            this.sendPacket(value ? UpdateAction.ADD : UpdateAction.REMOVE);
        }
    }

    private void sendPacket(UpdateAction action) {
        for (UUID uuid : new ArrayList<UUID>(this.players)) {
            ByteBuf buf = this.getPacket(action);
            this.sendPacket(uuid, buf);
        }
    }

    private void sendPacket(UUID uuid, ByteBuf buf) {
        if (!ViaVersion.getInstance().isPorted(uuid) || ViaVersion.getInstance().getPlayerVersion(uuid) < ProtocolVersion.v1_9.getId()) {
            this.players.remove(uuid);
            buf.release();
            return;
        }
        ViaVersion.getInstance().sendRawPacket(uuid, buf);
    }

    private ByteBuf getPacket(UpdateAction action) {
        try {
            ByteBuf buf = Unpooled.buffer();
            Type.VAR_INT.write(buf, 12);
            Type.UUID.write(buf, this.uuid);
            Type.VAR_INT.write(buf, action.getId());
            switch (action) {
                case ADD: {
                    Type.STRING.write(buf, this.fixJson(this.title));
                    buf.writeFloat(this.health);
                    Type.VAR_INT.write(buf, this.color.getId());
                    Type.VAR_INT.write(buf, this.style.getId());
                    buf.writeByte(this.flagToBytes());
                    break;
                }
                case REMOVE: {
                    break;
                }
                case UPDATE_HEALTH: {
                    buf.writeFloat(this.health);
                    break;
                }
                case UPDATE_TITLE: {
                    Type.STRING.write(buf, this.fixJson(this.title));
                    break;
                }
                case UPDATE_STYLE: {
                    Type.VAR_INT.write(buf, this.color.getId());
                    Type.VAR_INT.write(buf, this.style.getId());
                    break;
                }
                case UPDATE_FLAGS: {
                    buf.writeByte(this.flagToBytes());
                }
            }
            return buf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private int flagToBytes() {
        int bitmask = 0;
        for (BossFlag flag : this.flags) {
            bitmask |= flag.getId();
        }
        return bitmask;
    }

    private String fixJson(String text) {
        return Protocol1_9TO1_8.fixJson(text);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public BossStyle getStyle() {
        return this.style;
    }

    public Set<BossFlag> getFlags() {
        return this.flags;
    }

    private static enum UpdateAction {
        ADD(0),
        REMOVE(1),
        UPDATE_HEALTH(2),
        UPDATE_TITLE(3),
        UPDATE_STYLE(4),
        UPDATE_FLAGS(5);

        private final int id;

        private UpdateAction(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

