/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.protocol;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ProtocolVersion {
    private static final Map<Integer, ProtocolVersion> versions = new HashMap<Integer, ProtocolVersion>();
    private static final List<ProtocolVersion> versionList = new ArrayList<ProtocolVersion>();
    public static final ProtocolVersion v1_4_6 = new ProtocolVersion(51, "1.4.6");
    public static final ProtocolVersion v1_5_1;
    public static final ProtocolVersion v1_5_2;
    public static final ProtocolVersion v_1_6_1;
    public static final ProtocolVersion v_1_6_2;
    public static final ProtocolVersion v_1_6_3;
    public static final ProtocolVersion v_1_6_4;
    public static final ProtocolVersion v1_7_1;
    public static final ProtocolVersion v1_7_6;
    public static final ProtocolVersion v1_8;
    public static final ProtocolVersion v1_9;
    public static final ProtocolVersion v1_9_1;
    public static final ProtocolVersion v1_9_2;
    public static final ProtocolVersion v1_9_3;
    public static final ProtocolVersion v1_10;
    public static final ProtocolVersion unknown;
    private final int id;
    private final String name;

    public static void register(@NonNull ProtocolVersion protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol");
        }
        versions.put(protocol.getId(), protocol);
        versionList.add(protocol);
    }

    public static boolean isRegistered(int id) {
        return versions.containsKey(id);
    }

    public static ProtocolVersion getProtocol(int id) {
        if (versions.containsKey(id)) {
            return versions.get(id);
        }
        return new ProtocolVersion(id, "Unknown (" + id + ")");
    }

    public static int getIndex(ProtocolVersion version) {
        return versionList.indexOf(version);
    }

    public static List<ProtocolVersion> getProtocols() {
        return Collections.unmodifiableList(new ArrayList<ProtocolVersion>(versions.values()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolVersion that = (ProtocolVersion)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return String.format("%s(%d)", this.getName(), this.getId());
    }

    @ConstructorProperties(value={"id", "name"})
    public ProtocolVersion(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        ProtocolVersion.register(v1_4_6);
        v1_5_1 = new ProtocolVersion(60, "1.5.1");
        ProtocolVersion.register(v1_5_1);
        v1_5_2 = new ProtocolVersion(61, "1.5.2");
        ProtocolVersion.register(v1_5_2);
        v_1_6_1 = new ProtocolVersion(73, "1.6.1");
        ProtocolVersion.register(v_1_6_1);
        v_1_6_2 = new ProtocolVersion(74, "1.6.2");
        ProtocolVersion.register(v_1_6_2);
        v_1_6_3 = new ProtocolVersion(77, "1.6.3");
        ProtocolVersion.register(v_1_6_3);
        v_1_6_4 = new ProtocolVersion(78, "1.6.4");
        ProtocolVersion.register(v_1_6_4);
        v1_7_1 = new ProtocolVersion(4, "1.7-1.7.5");
        ProtocolVersion.register(v1_7_1);
        v1_7_6 = new ProtocolVersion(5, "1.7.6-1.7.10");
        ProtocolVersion.register(v1_7_6);
        v1_8 = new ProtocolVersion(47, "1.8.x");
        ProtocolVersion.register(v1_8);
        v1_9 = new ProtocolVersion(107, "1.9");
        ProtocolVersion.register(v1_9);
        v1_9_1 = new ProtocolVersion(108, "1.9.1");
        ProtocolVersion.register(v1_9_1);
        v1_9_2 = new ProtocolVersion(109, "1.9.2");
        ProtocolVersion.register(v1_9_2);
        v1_9_3 = new ProtocolVersion(110, "1.9.3/4");
        ProtocolVersion.register(v1_9_3);
        v1_10 = new ProtocolVersion(210, "1.10");
        ProtocolVersion.register(v1_10);
        unknown = new ProtocolVersion(-1, "UNKNOWN");
        ProtocolVersion.register(unknown);
    }
}

