/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.protocols.base.BaseProtocol;
import us.myles.ViaVersion.protocols.protocol1_10to1_9_3.Protocol1_10To1_9_3_4;
import us.myles.ViaVersion.protocols.protocol1_9_1_2to1_9_3_4.Protocol1_9_1_2TO1_9_3_4;
import us.myles.ViaVersion.protocols.protocol1_9_1to1_9.Protocol1_9_1TO1_9;
import us.myles.ViaVersion.protocols.protocol1_9_3to1_9_1_2.Protocol1_9_3TO1_9_1_2;
import us.myles.ViaVersion.protocols.protocol1_9to1_8.Protocol1_9TO1_8;
import us.myles.ViaVersion.protocols.protocol1_9to1_9_1.Protocol1_9TO1_9_1;

public class ProtocolRegistry {
    public static final Protocol BASE_PROTOCOL = new BaseProtocol();
    public static int SERVER_PROTOCOL = -1;
    private static Map<Integer, Map<Integer, Protocol>> registryMap = new ConcurrentHashMap<Integer, Map<Integer, Protocol>>();
    private static Map<Pair<Integer, Integer>, List<Pair<Integer, Protocol>>> pathCache = new ConcurrentHashMap<Pair<Integer, Integer>, List<Pair<Integer, Protocol>>>();
    private static List<Protocol> registerList = Lists.newCopyOnWriteArrayList();
    private static Set<Integer> supportedVersions = Sets.newConcurrentHashSet();

    public static void registerProtocol(Protocol protocol, List<Integer> supported, Integer output) {
        if (pathCache.size() > 0) {
            pathCache.clear();
        }
        for (Integer version : supported) {
            if (!registryMap.containsKey(version)) {
                registryMap.put(version, new HashMap());
            }
            registryMap.get(version).put(output, protocol);
        }
        if (Bukkit.getPluginManager().getPlugin("ViaVersion").isEnabled()) {
            protocol.registerListeners();
            ProtocolRegistry.refreshVersions();
        } else {
            registerList.add(protocol);
        }
    }

    public static void refreshVersions() {
        supportedVersions.clear();
        supportedVersions.add(SERVER_PROTOCOL);
        for (ProtocolVersion versions : ProtocolVersion.getProtocols()) {
            List<Pair<Integer, Protocol>> paths = ProtocolRegistry.getProtocolPath(versions.getId(), SERVER_PROTOCOL);
            if (paths == null) continue;
            supportedVersions.add(versions.getId());
            for (Pair<Integer, Protocol> path : paths) {
                supportedVersions.add(path.getKey());
            }
        }
    }

    public static SortedSet<Integer> getSupportedVersions() {
        return Collections.unmodifiableSortedSet(new TreeSet<Integer>(supportedVersions));
    }

    public static boolean isWorkingPipe() {
        for (Map<Integer, Protocol> maps : registryMap.values()) {
            if (!maps.containsKey(SERVER_PROTOCOL)) continue;
            return true;
        }
        return false;
    }

    public static void registerListeners() {
        for (Protocol protocol : registerList) {
            protocol.registerListeners();
        }
        registerList.clear();
    }

    private static List<Pair<Integer, Protocol>> getProtocolPath(List<Pair<Integer, Protocol>> current, int clientVersion, int serverVersion) {
        if (clientVersion == serverVersion) {
            return null;
        }
        if (current.size() > 50) {
            return null;
        }
        if (!registryMap.containsKey(clientVersion)) {
            return null;
        }
        Map<Integer, Protocol> inputMap = registryMap.get(clientVersion);
        if (inputMap.containsKey(serverVersion)) {
            current.add(new Pair<Integer, Protocol>(serverVersion, inputMap.get(serverVersion)));
            return current;
        }
        List<Pair<Integer, Protocol>> shortest = null;
        for (Map.Entry<Integer, Protocol> entry : inputMap.entrySet()) {
            Pair<Integer, Protocol> pair;
            if (entry.getKey().equals(serverVersion) || current.contains(pair = new Pair<Integer, Protocol>(entry.getKey(), entry.getValue()))) continue;
            List<Pair<Integer, Protocol>> newCurrent = new ArrayList<Pair<Integer, Protocol>>(current);
            newCurrent.add(pair);
            if ((newCurrent = ProtocolRegistry.getProtocolPath(newCurrent, entry.getKey(), serverVersion)) == null || shortest != null && shortest.size() <= newCurrent.size()) continue;
            shortest = newCurrent;
        }
        return shortest;
    }

    public static List<Pair<Integer, Protocol>> getProtocolPath(int clientVersion, int serverVersion) {
        Pair<Integer, Integer> protocolKey = new Pair<Integer, Integer>(clientVersion, serverVersion);
        if (pathCache.containsKey(protocolKey)) {
            return pathCache.get(protocolKey);
        }
        List<Pair<Integer, Protocol>> outputPath = ProtocolRegistry.getProtocolPath(new ArrayList<Pair<Integer, Protocol>>(), clientVersion, serverVersion);
        if (outputPath != null) {
            pathCache.put(protocolKey, outputPath);
        }
        return outputPath;
    }

    static {
        ProtocolRegistry.registerProtocol(BASE_PROTOCOL, Arrays.asList(new Integer[0]), -1);
        ProtocolRegistry.registerProtocol(new Protocol1_9TO1_8(), Collections.singletonList(ProtocolVersion.v1_9.getId()), ProtocolVersion.v1_8.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9_1TO1_9(), Arrays.asList(ProtocolVersion.v1_9_1.getId(), ProtocolVersion.v1_9_2.getId()), ProtocolVersion.v1_9.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9_3TO1_9_1_2(), Arrays.asList(ProtocolVersion.v1_9_3.getId()), ProtocolVersion.v1_9_2.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9TO1_9_1(), Arrays.asList(ProtocolVersion.v1_9.getId()), ProtocolVersion.v1_9_2.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_9_1_2TO1_9_3_4(), Arrays.asList(ProtocolVersion.v1_9_1.getId(), ProtocolVersion.v1_9_2.getId()), ProtocolVersion.v1_9_3.getId());
        ProtocolRegistry.registerProtocol(new Protocol1_10To1_9_3_4(), Collections.singletonList(ProtocolVersion.v1_10.getId()), ProtocolVersion.v1_9_3.getId());
    }
}

