/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion.api;

import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;

public abstract class ViaListener
implements Listener {
    private final ViaVersionPlugin plugin;
    private final Class<? extends Protocol> requiredPipeline;
    private boolean registered = false;

    protected UserConnection getUserConnection(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        return this.getUserConnection(player.getUniqueId());
    }

    protected UserConnection getUserConnection(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid");
        }
        if (!this.plugin.isPorted(uuid)) {
            return null;
        }
        return this.plugin.getConnection(uuid);
    }

    protected boolean isOnPipe(Player player) {
        return this.isOnPipe(player.getUniqueId());
    }

    protected boolean isOnPipe(UUID uuid) {
        UserConnection userConnection = this.getUserConnection(uuid);
        return userConnection != null && userConnection.get(ProtocolInfo.class).getPipeline().contains(this.requiredPipeline);
    }

    public void register() {
        if (this.registered) {
            return;
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.registered = true;
    }

    protected ViaVersionPlugin getPlugin() {
        return this.plugin;
    }

    protected Class<? extends Protocol> getRequiredPipeline() {
        return this.requiredPipeline;
    }

    protected boolean isRegistered() {
        return this.registered;
    }

    @ConstructorProperties(value={"plugin", "requiredPipeline"})
    public ViaListener(ViaVersionPlugin plugin, Class<? extends Protocol> requiredPipeline) {
        this.plugin = plugin;
        this.requiredPipeline = requiredPipeline;
    }
}

