/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import us.myles.ViaVersion.ViaConfig;
import us.myles.ViaVersion.api.Pair;
import us.myles.ViaVersion.api.ViaVersion;
import us.myles.ViaVersion.api.ViaVersionAPI;
import us.myles.ViaVersion.api.boss.BossBar;
import us.myles.ViaVersion.api.boss.BossColor;
import us.myles.ViaVersion.api.boss.BossStyle;
import us.myles.ViaVersion.api.command.ViaVersionCommand;
import us.myles.ViaVersion.api.data.UserConnection;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.api.protocol.ProtocolVersion;
import us.myles.ViaVersion.boss.ViaBossBar;
import us.myles.ViaVersion.classgenerator.ClassGenerator;
import us.myles.ViaVersion.commands.ViaCommandHandler;
import us.myles.ViaVersion.handlers.ViaVersionInitializer;
import us.myles.ViaVersion.protocols.base.ProtocolInfo;
import us.myles.ViaVersion.update.UpdateListener;
import us.myles.ViaVersion.update.UpdateUtil;
import us.myles.ViaVersion.util.ConcurrentList;
import us.myles.ViaVersion.util.ListWrapper;
import us.myles.ViaVersion.util.ProtocolSupportUtil;
import us.myles.ViaVersion.util.ReflectionUtil;

public class ViaVersionPlugin
extends JavaPlugin
implements ViaVersionAPI {
    private final Map<UUID, UserConnection> portedPlayers = new ConcurrentHashMap<UUID, UserConnection>();
    private List<ChannelFuture> injectedFutures = new ArrayList<ChannelFuture>();
    private List<Pair<Field, Object>> injectedLists = new ArrayList<Pair<Field, Object>>();
    private ViaCommandHandler commandHandler;
    private boolean debug = false;
    private boolean compatSpigotBuild = false;
    private boolean spigot = true;
    private boolean lateBind = false;
    private boolean protocolSupport = false;
    private ViaConfig conf;

    public ViaVersionPlugin() {
        boolean bl = this.protocolSupport = Bukkit.getPluginManager().getPlugin("ProtocolSupport") != null;
        if (this.protocolSupport) {
            this.getLogger().info("Hooking into ProtocolSupport, to prevent issues!");
            try {
                this.patchLists();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onLoad() {
        this.conf = new ViaConfig(this);
        ViaVersion.setInstance(this);
        if (System.getProperty("ViaVersion") != null) {
            if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null) {
                this.getLogger().severe("ViaVersion is already loaded, we're going to kick all the players... because otherwise we'll crash because of ProtocolLib.");
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConf().getReloadDisconnectMsg()));
                }
            } else {
                this.getLogger().severe("ViaVersion is already loaded, this should work fine. If you get any console errors, try rebooting.");
            }
        }
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (ClassNotFoundException e) {
            this.spigot = false;
        }
        try {
            this.compatSpigotBuild = ReflectionUtil.nms("PacketEncoder").getDeclaredField("version") != null;
        }
        catch (Exception e) {
            this.compatSpigotBuild = false;
        }
        ClassGenerator.generate();
        this.lateBind = !this.isBinded();
        this.getLogger().info("ViaVersion " + this.getDescription().getVersion() + (this.compatSpigotBuild ? "compat" : "") + " is now loaded" + (this.lateBind ? ", waiting for boot. (late-bind)" : ", injecting!"));
        if (!this.lateBind) {
            this.injectPacketHandler();
        }
    }

    public void onEnable() {
        if (this.lateBind) {
            this.injectPacketHandler();
        }
        if (this.conf.isCheckForUpdates()) {
            UpdateUtil.sendUpdateMessage((Plugin)this);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                ViaVersionPlugin.this.gatherProtocolVersion();
                if (ProtocolRegistry.SERVER_PROTOCOL != -1) {
                    ViaVersionPlugin.this.getLogger().info("ViaVersion detected server version: " + ProtocolVersion.getProtocol(ProtocolRegistry.SERVER_PROTOCOL));
                    if (!ProtocolRegistry.isWorkingPipe()) {
                        ViaVersionPlugin.this.getLogger().warning("ViaVersion does not have any compatible versions for this server version, please read our resource page carefully.");
                    }
                }
                ProtocolRegistry.refreshVersions();
            }
        });
        Bukkit.getPluginManager().registerEvents((Listener)new UpdateListener(this), (Plugin)this);
        this.commandHandler = new ViaCommandHandler();
        this.getCommand("viaversion").setExecutor((CommandExecutor)this.commandHandler);
        this.getCommand("viaversion").setTabCompleter((TabCompleter)this.commandHandler);
        ProtocolRegistry.registerListeners();
        if (this.conf.isAntiXRay() && !this.spigot) {
            this.getLogger().info("You have anti-xray on in your config, since you're not using spigot it won't fix xray!");
        }
    }

    public void onDisable() {
        this.getLogger().info("ViaVersion is disabling, if this is a reload and you experience issues consider rebooting.");
        this.uninject();
    }

    public void gatherProtocolVersion() {
        try {
            Class<?> serverClazz = ReflectionUtil.nms("MinecraftServer");
            Object server = ReflectionUtil.invokeStatic(serverClazz, "getServer");
            Class<?> pingClazz = ReflectionUtil.nms("ServerPing");
            Object ping = null;
            for (Field f : serverClazz.getDeclaredFields()) {
                if (f.getType() == null || !f.getType().getSimpleName().equals("ServerPing")) continue;
                f.setAccessible(true);
                ping = f.get(server);
            }
            if (ping != null) {
                Object serverData = null;
                for (Field f : pingClazz.getDeclaredFields()) {
                    if (f.getType() == null || !f.getType().getSimpleName().endsWith("ServerData")) continue;
                    f.setAccessible(true);
                    serverData = f.get(ping);
                }
                if (serverData != null) {
                    int protocolVersion = -1;
                    for (Field f : serverData.getClass().getDeclaredFields()) {
                        if (f.getType() == null || f.getType() != Integer.TYPE) continue;
                        f.setAccessible(true);
                        protocolVersion = (Integer)f.get(serverData);
                    }
                    if (protocolVersion != -1) {
                        ProtocolRegistry.SERVER_PROTOCOL = protocolVersion;
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getServerConnection() throws Exception {
        Class<?> serverClazz = ReflectionUtil.nms("MinecraftServer");
        Object server = ReflectionUtil.invokeStatic(serverClazz, "getServer");
        Object connection = null;
        for (Method m : serverClazz.getDeclaredMethods()) {
            if (m.getReturnType() == null || !m.getReturnType().getSimpleName().equals("ServerConnection") || m.getParameterTypes().length != 0) continue;
            connection = m.invoke(server, new Object[0]);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectPacketHandler() {
        try {
            Object connection = this.getServerConnection();
            if (connection == null) {
                this.getLogger().warning("We failed to find the core component 'ServerConnection', please file an issue on our GitHub.");
                return;
            }
            for (Field field : connection.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(connection);
                if (!(value instanceof List)) continue;
                ListWrapper wrapper = new ListWrapper((List)value){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void handleAdd(Object o) {
                        2 var2_2 = this;
                        synchronized (var2_2) {
                            if (o instanceof ChannelFuture) {
                                ViaVersionPlugin.this.inject((ChannelFuture)o);
                            }
                        }
                    }
                };
                this.injectedLists.add(new Pair<Field, Object>(field, connection));
                field.set(connection, wrapper);
                ListWrapper listWrapper = wrapper;
                synchronized (listWrapper) {
                    for (Object o : (List)value) {
                        if (!(o instanceof ChannelFuture)) break;
                        this.inject((ChannelFuture)o);
                    }
                }
            }
            System.setProperty("ViaVersion", this.getDescription().getVersion());
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to inject ViaVersion, please post these details on our GitHub and ensure you're using a compatible server version.");
            e.printStackTrace();
        }
    }

    public void patchLists() throws Exception {
        Object connection = this.getServerConnection();
        if (connection == null) {
            this.getLogger().warning("We failed to find the core component 'ServerConnection', please file an issue on our GitHub.");
            return;
        }
        for (Field field : connection.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = field.get(connection);
            if (!(value instanceof List) || value instanceof ConcurrentList) continue;
            ConcurrentList list = new ConcurrentList();
            list.addAll((List)value);
            field.set(connection, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinded() {
        try {
            Object connection = this.getServerConnection();
            if (connection == null) {
                return false;
            }
            for (Field field : connection.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(connection);
                if (!(value instanceof List)) continue;
                Object object = value;
                synchronized (object) {
                    Object o;
                    Iterator i$ = ((List)value).iterator();
                    if (i$.hasNext() && (o = i$.next()) instanceof ChannelFuture) {
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void inject(ChannelFuture future) {
        try {
            ChannelHandler bootstrapAcceptor = future.channel().pipeline().first();
            try {
                ChannelInitializer oldInit = ReflectionUtil.get(bootstrapAcceptor, "childHandler", ChannelInitializer.class);
                ViaVersionInitializer newInit = new ViaVersionInitializer((ChannelInitializer<SocketChannel>)oldInit);
                ReflectionUtil.set(bootstrapAcceptor, "childHandler", (Object)newInit);
                this.injectedFutures.add(future);
            }
            catch (NoSuchFieldException e) {
                ClassLoader cl = bootstrapAcceptor.getClass().getClassLoader();
                if (cl.getClass().getName().equals("org.bukkit.plugin.java.PluginClassLoader")) {
                    PluginDescriptionFile yaml = ReflectionUtil.get(cl, "description", PluginDescriptionFile.class);
                    throw new Exception("Unable to inject, due to " + bootstrapAcceptor.getClass().getName() + ", try without the plugin " + yaml.getName() + "?");
                }
                throw new Exception("Unable to find core component 'childHandler', please check your plugins. issue: " + bootstrapAcceptor.getClass().getName());
            }
        }
        catch (Exception e) {
            this.getLogger().severe("We failed to inject ViaVersion, have you got late-bind enabled with something else?");
            e.printStackTrace();
        }
    }

    private void uninject() {
        for (ChannelFuture channelFuture : this.injectedFutures) {
            ChannelHandler bootstrapAcceptor = channelFuture.channel().pipeline().first();
            try {
                ChannelInitializer oldInit = ReflectionUtil.get(bootstrapAcceptor, "childHandler", ChannelInitializer.class);
                if (!(oldInit instanceof ViaVersionInitializer)) continue;
                ReflectionUtil.set(bootstrapAcceptor, "childHandler", ((ViaVersionInitializer)oldInit).getOriginal());
            }
            catch (Exception e) {
                System.out.println("Failed to remove injection handler, reload won't work with connections, please reboot!");
            }
        }
        this.injectedFutures.clear();
        for (Pair pair : this.injectedLists) {
            try {
                Object o = ((Field)pair.getKey()).get(pair.getValue());
                if (!(o instanceof ListWrapper)) continue;
                ((Field)pair.getKey()).set(pair.getValue(), ((ListWrapper)o).getOriginalList());
            }
            catch (IllegalAccessException e) {
                System.out.println("Failed to remove injection, reload won't work with connections, please reboot!");
            }
        }
        this.injectedLists.clear();
    }

    @Override
    public boolean isPorted(Player player) {
        return this.isPorted(player.getUniqueId());
    }

    @Override
    public int getPlayerVersion(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (!this.isPorted(player)) {
            return this.getExternalVersion(player);
        }
        return this.portedPlayers.get(player.getUniqueId()).get(ProtocolInfo.class).getProtocolVersion();
    }

    @Override
    public int getPlayerVersion(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid");
        }
        if (!this.isPorted(uuid)) {
            return this.getExternalVersion(Bukkit.getPlayer((UUID)uuid));
        }
        return this.portedPlayers.get(uuid).get(ProtocolInfo.class).getProtocolVersion();
    }

    private int getExternalVersion(Player player) {
        if (!this.isProtocolSupport()) {
            return ProtocolRegistry.SERVER_PROTOCOL;
        }
        return ProtocolSupportUtil.getProtocolVersion(player);
    }

    @Override
    public boolean isPorted(UUID playerUUID) {
        return this.portedPlayers.containsKey(playerUUID);
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public UserConnection getConnection(UUID playerUUID) {
        return this.portedPlayers.get(playerUUID);
    }

    public UserConnection getConnection(Player player) {
        return this.portedPlayers.get(player.getUniqueId());
    }

    @Override
    public void sendRawPacket(Player player, ByteBuf packet) throws IllegalArgumentException {
        this.sendRawPacket(player.getUniqueId(), packet);
    }

    @Override
    public void sendRawPacket(UUID uuid, ByteBuf packet) throws IllegalArgumentException {
        if (!this.isPorted(uuid)) {
            throw new IllegalArgumentException("This player is not controlled by ViaVersion!");
        }
        UserConnection ci = this.portedPlayers.get(uuid);
        ci.sendRawPacket(packet);
    }

    @Override
    public BossBar createBossBar(String title, BossColor color, BossStyle style) {
        return new ViaBossBar(title, 1.0f, color, style);
    }

    @Override
    public BossBar createBossBar(String title, float health, BossColor color, BossStyle style) {
        return new ViaBossBar(title, health, color, style);
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    @Override
    public ViaVersionCommand getCommandHandler() {
        return this.commandHandler;
    }

    @Override
    public boolean isCompatSpigotBuild() {
        return this.compatSpigotBuild;
    }

    @Override
    public SortedSet<Integer> getSupportedVersions() {
        TreeSet<Integer> outputSet = new TreeSet<Integer>(ProtocolRegistry.getSupportedVersions());
        outputSet.removeAll(this.getConf().getBlockedProtocols());
        return outputSet;
    }

    @Override
    public boolean isSpigot() {
        return this.spigot;
    }

    public void addPortedClient(UserConnection info) {
        this.portedPlayers.put(info.get(ProtocolInfo.class).getUuid(), info);
    }

    public void removePortedClient(UUID clientID) {
        this.portedPlayers.remove(clientID);
    }

    public void run(final Runnable runnable, boolean wait) {
        block3: {
            try {
                Future f = Bukkit.getScheduler().callSyncMethod(Bukkit.getPluginManager().getPlugin("ViaVersion"), (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        runnable.run();
                        return true;
                    }
                });
                if (wait) {
                    f.get(10L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to run task: " + e.getClass().getName());
                if (!ViaVersion.getInstance().isDebug()) break block3;
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isProtocolSupport() {
        return this.protocolSupport;
    }

    public Map<UUID, UserConnection> getPortedPlayers() {
        return this.portedPlayers;
    }

    public boolean handlePPS(UserConnection info) {
        if (this.conf.getMaxPPS() > 0 && info.getPacketsPerSecond() >= (long)this.conf.getMaxPPS()) {
            info.disconnect(this.conf.getMaxPPSKickMessage().replace("%pps", Long.valueOf(info.getPacketsPerSecond()).intValue() + ""));
            return true;
        }
        if (this.conf.getMaxWarnings() > 0 && this.conf.getTrackingPeriod() > 0) {
            if (info.getSecondsObserved() > this.conf.getTrackingPeriod()) {
                info.setWarnings(0);
                info.setSecondsObserved(1);
            } else {
                info.setSecondsObserved(info.getSecondsObserved() + 1);
                if (info.getPacketsPerSecond() >= (long)this.conf.getWarningPPS()) {
                    info.setWarnings(info.getWarnings() + 1);
                }
                if (info.getWarnings() >= this.conf.getMaxWarnings()) {
                    info.disconnect(this.conf.getMaxWarningsKickMessage().replace("%pps", Long.valueOf(info.getPacketsPerSecond()).intValue() + ""));
                    return true;
                }
            }
        }
        return false;
    }

    public ViaConfig getConf() {
        return this.conf;
    }
}

