/*
 * Decompiled with CFR 0.152.
 */
package us.myles.ViaVersion;

import java.io.File;
import java.util.List;
import us.myles.ViaVersion.ViaVersionPlugin;
import us.myles.ViaVersion.api.ViaVersionConfig;
import us.myles.ViaVersion.util.Configuration;

public class ViaConfig
implements ViaVersionConfig {
    private final ViaVersionPlugin plugin;

    public ViaConfig(ViaVersionPlugin plugin) {
        this.plugin = plugin;
        this.generateConfig();
    }

    public void generateConfig() {
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (file.exists()) {
            Configuration oldConfig = new Configuration(file);
            oldConfig.reload(false);
            file.delete();
            this.plugin.saveDefaultConfig();
            Configuration newConfig = new Configuration(file);
            newConfig.reload(true);
            for (String key : oldConfig.getKeys(false)) {
                if (!newConfig.contains(key)) continue;
                newConfig.set(key, oldConfig.get(key));
            }
            newConfig.save();
        } else {
            this.plugin.saveDefaultConfig();
        }
    }

    @Override
    public boolean isCheckForUpdates() {
        return this.plugin.getConfig().getBoolean("checkforupdates", true);
    }

    @Override
    public boolean isPreventCollision() {
        return this.plugin.getConfig().getBoolean("prevent-collision", true);
    }

    @Override
    public boolean isNewEffectIndicator() {
        return this.plugin.getConfig().getBoolean("use-new-effect-indicator", true);
    }

    @Override
    public boolean isShowNewDeathMessages() {
        return this.plugin.getConfig().getBoolean("use-new-deathmessages", false);
    }

    @Override
    public boolean isSuppressMetadataErrors() {
        return this.plugin.getConfig().getBoolean("suppress-metadata-errors", false);
    }

    @Override
    public boolean isShieldBlocking() {
        return this.plugin.getConfig().getBoolean("shield-blocking", true);
    }

    @Override
    public boolean isHologramPatch() {
        return this.plugin.getConfig().getBoolean("hologram-patch", false);
    }

    @Override
    public boolean isBossbarPatch() {
        return this.plugin.getConfig().getBoolean("bossbar-patch", true);
    }

    @Override
    public boolean isBossbarAntiflicker() {
        return this.plugin.getConfig().getBoolean("bossbar-anti-flicker", false);
    }

    @Override
    public boolean isUnknownEntitiesSuppressed() {
        return false;
    }

    @Override
    public double getHologramYOffset() {
        return this.plugin.getConfig().getDouble("hologram-y", -0.96);
    }

    @Override
    public boolean isBlockBreakPatch() {
        return false;
    }

    @Override
    public int getMaxPPS() {
        return this.plugin.getConfig().getInt("max-pps", 140);
    }

    @Override
    public String getMaxPPSKickMessage() {
        return this.plugin.getConfig().getString("max-pps-kick-msg", "Sending packets too fast? lag?");
    }

    @Override
    public int getTrackingPeriod() {
        return this.plugin.getConfig().getInt("tracking-period", 6);
    }

    @Override
    public int getWarningPPS() {
        return this.plugin.getConfig().getInt("tracking-warning-pps", 120);
    }

    @Override
    public int getMaxWarnings() {
        return this.plugin.getConfig().getInt("tracking-max-warnings", 3);
    }

    @Override
    public String getMaxWarningsKickMessage() {
        return this.plugin.getConfig().getString("tracking-max-kick-msg", "You are sending too many packets, :(");
    }

    @Override
    public boolean isAntiXRay() {
        return this.plugin.getConfig().getBoolean("anti-xray-patch", true);
    }

    @Override
    public boolean isSendSupportedVersions() {
        return this.plugin.getConfig().getBoolean("send-supported-versions", false);
    }

    @Override
    public boolean isStimulatePlayerTick() {
        return this.plugin.getConfig().getBoolean("simulate-pt", true);
    }

    @Override
    public boolean isItemCache() {
        return this.plugin.getConfig().getBoolean("item-cache", true);
    }

    @Override
    public boolean isNMSPlayerTicking() {
        return this.plugin.getConfig().getBoolean("nms-player-ticking", true);
    }

    @Override
    public boolean isReplacePistons() {
        return this.plugin.getConfig().getBoolean("replace-pistons", false);
    }

    @Override
    public int getPistonReplacementId() {
        return this.plugin.getConfig().getInt("replacement-piston-id", 0);
    }

    @Override
    public boolean isAutoTeam() {
        return this.isPreventCollision() && this.plugin.getConfig().getBoolean("auto-team", true);
    }

    @Override
    public boolean isForceJsonTransform() {
        return this.plugin.getConfig().getBoolean("force-json-transform", false);
    }

    @Override
    public List<Integer> getBlockedProtocols() {
        return this.plugin.getConfig().getIntegerList("block-protocols");
    }

    @Override
    public String getBlockedDisconnectMsg() {
        return this.plugin.getConfig().getString("block-disconnect-msg", "You are using an unsupported Minecraft version!");
    }

    @Override
    public String getReloadDisconnectMsg() {
        return this.plugin.getConfig().getString("reload-disconnect-msg", "Server reload, please rejoin!");
    }
}

