/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import org.bukkit.Server;

public class Commandtpa
extends EssentialsCommand {
    public Commandtpa() {
        super("tpa");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User player = this.getPlayer(server, user, args, 0);
        if (user.getName().equalsIgnoreCase(player.getName())) {
            throw new NotEnoughArgumentsException();
        }
        if (!player.isTeleportEnabled()) {
            throw new Exception(I18n.tl("teleportDisabled", player.getDisplayName()));
        }
        if (user.getWorld() != player.getWorld() && this.ess.getSettings().isWorldTeleportPermissions() && !user.isAuthorized("essentials.worlds." + player.getWorld().getName())) {
            throw new Exception(I18n.tl("noPerm", "essentials.worlds." + player.getWorld().getName()));
        }
        if (!player.isIgnoredPlayer(user)) {
            player.requestTeleport(user, false);
            player.sendMessage(I18n.tl("teleportRequest", user.getDisplayName()));
            player.sendMessage(I18n.tl("typeTpaccept", new Object[0]));
            player.sendMessage(I18n.tl("typeTpdeny", new Object[0]));
            if (this.ess.getSettings().getTpaAcceptCancellation() != 0L) {
                player.sendMessage(I18n.tl("teleportRequestTimeoutInfo", this.ess.getSettings().getTpaAcceptCancellation()));
            }
        }
        user.sendMessage(I18n.tl("requestSent", player.getDisplayName()));
    }
}

