/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.ManagedFile;
import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.NumberUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import net.ess3.api.IItemDb;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;

public class ItemDb
implements IConf,
IItemDb {
    private final transient IEssentials ess;
    private final transient Map<String, Integer> items = new HashMap<String, Integer>();
    private final transient Map<ItemData, List<String>> names = new HashMap<ItemData, List<String>>();
    private final transient Map<ItemData, String> primaryName = new HashMap<ItemData, String>();
    private final transient Map<String, Short> durabilities = new HashMap<String, Short>();
    private final transient ManagedFile file;
    private final transient Pattern splitPattern = Pattern.compile("((.*)[:+',;.](\\d+))");

    public ItemDb(IEssentials ess) {
        this.ess = ess;
        this.file = new ManagedFile("items.csv", ess);
    }

    @Override
    public void reloadConfig() {
        List<String> lines = this.file.getLines();
        if (lines.isEmpty()) {
            return;
        }
        this.durabilities.clear();
        this.items.clear();
        this.names.clear();
        this.primaryName.clear();
        for (String line : lines) {
            List<Object> nameList;
            String[] parts;
            if ((line = line.trim().toLowerCase(Locale.ENGLISH)).length() > 0 && line.charAt(0) == '#' || (parts = line.split("[^a-z0-9]")).length < 2) continue;
            int numeric = Integer.parseInt(parts[1]);
            short data = parts.length > 2 && !parts[2].equals("0") ? Short.parseShort(parts[2]) : (short)0;
            String itemName = parts[0].toLowerCase(Locale.ENGLISH);
            this.durabilities.put(itemName, data);
            this.items.put(itemName, numeric);
            ItemData itemData = new ItemData(numeric, data);
            if (this.names.containsKey(itemData)) {
                nameList = this.names.get(itemData);
                nameList.add(itemName);
                Collections.sort(nameList, new LengthCompare());
                continue;
            }
            nameList = new ArrayList<String>();
            nameList.add(itemName);
            this.names.put(itemData, nameList);
            this.primaryName.put(itemData, itemName);
        }
    }

    @Override
    public ItemStack get(String id, int quantity) throws Exception {
        ItemStack retval = this.get(id.toLowerCase(Locale.ENGLISH));
        retval.setAmount(quantity);
        return retval;
    }

    @Override
    public ItemStack get(String id) throws Exception {
        int itemid = 0;
        String itemname = null;
        short metaData = 0;
        Matcher parts = this.splitPattern.matcher(id);
        if (parts.matches()) {
            itemname = parts.group(2);
            metaData = Short.parseShort(parts.group(3));
        } else {
            itemname = id;
        }
        if (NumberUtil.isInt(itemname)) {
            itemid = Integer.parseInt(itemname);
        } else if (NumberUtil.isInt(id)) {
            itemid = Integer.parseInt(id);
        } else {
            itemname = itemname.toLowerCase(Locale.ENGLISH);
        }
        if (itemid < 1) {
            Material bMaterial;
            if (this.items.containsKey(itemname)) {
                itemid = this.items.get(itemname);
                if (this.durabilities.containsKey(itemname) && metaData == 0) {
                    metaData = this.durabilities.get(itemname);
                }
            } else if (Material.getMaterial((String)itemname.toUpperCase(Locale.ENGLISH)) != null) {
                bMaterial = Material.getMaterial((String)itemname.toUpperCase(Locale.ENGLISH));
                itemid = bMaterial.getId();
            } else {
                try {
                    bMaterial = Bukkit.getUnsafe().getMaterialFromInternalName(itemname.toLowerCase(Locale.ENGLISH));
                    itemid = bMaterial.getId();
                }
                catch (Throwable throwable) {
                    throw new Exception(I18n.tl("unknownItemName", itemname), throwable);
                }
            }
        }
        if (itemid < 1) {
            throw new Exception(I18n.tl("unknownItemName", itemname));
        }
        Material mat = Material.getMaterial((int)itemid);
        if (mat == null) {
            throw new Exception(I18n.tl("unknownItemId", itemid));
        }
        ItemStack retval = new ItemStack(mat);
        if (mat == Material.MOB_SPAWNER) {
            if (metaData == 0) {
                metaData = EntityType.PIG.getTypeId();
            }
            try {
                retval = this.ess.getSpawnerProvider().setEntityType(retval, EntityType.fromId((int)metaData));
            }
            catch (IllegalArgumentException e) {
                throw new Exception("Can't spawn entity ID " + metaData + " from mob spawners.");
            }
        } else {
            retval.setDurability(metaData);
        }
        retval.setAmount(mat.getMaxStackSize());
        return retval;
    }

    @Override
    public List<ItemStack> getMatching(User user, String[] args) throws Exception {
        ArrayList<ItemStack> is = new ArrayList<ItemStack>();
        if (args.length < 1) {
            is.add(user.getBase().getItemInHand());
        } else if (args[0].equalsIgnoreCase("hand")) {
            is.add(user.getBase().getItemInHand());
        } else if (args[0].equalsIgnoreCase("inventory") || args[0].equalsIgnoreCase("invent") || args[0].equalsIgnoreCase("all")) {
            for (ItemStack stack : user.getBase().getInventory().getContents()) {
                if (stack == null || stack.getType() == Material.AIR) continue;
                is.add(stack);
            }
        } else if (args[0].equalsIgnoreCase("blocks")) {
            for (ItemStack stack : user.getBase().getInventory().getContents()) {
                if (stack == null || stack.getTypeId() > 255 || stack.getType() == Material.AIR) continue;
                is.add(stack);
            }
        } else {
            is.add(this.get(args[0]));
        }
        if (is.isEmpty() || ((ItemStack)is.get(0)).getType() == Material.AIR) {
            throw new Exception(I18n.tl("itemSellAir", new Object[0]));
        }
        return is;
    }

    @Override
    public String names(ItemStack item) {
        ItemData itemData = new ItemData(item.getTypeId(), item.getDurability());
        List<String> nameList = this.names.get(itemData);
        if (nameList == null && (nameList = this.names.get(itemData = new ItemData(item.getTypeId(), 0))) == null) {
            return null;
        }
        if (nameList.size() > 15) {
            nameList = nameList.subList(0, 14);
        }
        return StringUtil.joinList(", ", nameList);
    }

    @Override
    public String name(ItemStack item) {
        ItemData itemData = new ItemData(item.getTypeId(), item.getDurability());
        String name = this.primaryName.get(itemData);
        if (name == null && (name = this.primaryName.get(itemData = new ItemData(item.getTypeId(), 0))) == null) {
            return null;
        }
        return name;
    }

    @Override
    public String serialize(ItemStack is) {
        String mat = is.getType().name();
        if (is.getData().getData() != 0) {
            mat = mat + ":" + is.getData().getData();
        }
        int quantity = is.getAmount();
        StringBuilder sb = new StringBuilder();
        sb.append(mat).append(" ").append(quantity).append(" ");
        if (is.hasItemMeta()) {
            ItemMeta meta = is.getItemMeta();
            if (meta.hasDisplayName()) {
                sb.append("name:").append(meta.getDisplayName().replaceAll(" ", "_")).append(" ");
            }
            if (meta.hasLore()) {
                sb.append("lore:");
                boolean first = true;
                for (String s : meta.getLore()) {
                    if (!first) {
                        sb.append("|");
                    }
                    first = false;
                    sb.append(s.replaceAll(" ", "_"));
                }
                sb.append(" ");
            }
            if (meta.hasEnchants()) {
                for (Enchantment e : meta.getEnchants().keySet()) {
                    sb.append(e.getName().toLowerCase()).append(":").append(meta.getEnchantLevel(e)).append(" ");
                }
            }
        }
        switch (is.getType()) {
            case WRITTEN_BOOK: {
                BookMeta bookMeta = (BookMeta)is.getItemMeta();
                if (bookMeta.hasTitle()) {
                    sb.append("title:").append(bookMeta.getTitle()).append(" ");
                }
                if (!bookMeta.hasAuthor()) break;
                sb.append("author:").append(bookMeta.getAuthor()).append(" ");
                break;
            }
            case ENCHANTED_BOOK: {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)is.getItemMeta();
                for (Enchantment e : enchantmentStorageMeta.getStoredEnchants().keySet()) {
                    sb.append(e.getName().toLowerCase()).append(":").append(enchantmentStorageMeta.getStoredEnchantLevel(e)).append(" ");
                }
                break;
            }
            case FIREWORK: {
                FireworkMeta fireworkMeta = (FireworkMeta)is.getItemMeta();
                if (!fireworkMeta.hasEffects()) break;
                for (FireworkEffect effect : fireworkMeta.getEffects()) {
                    boolean first;
                    if (effect.getColors() != null && !effect.getColors().isEmpty()) {
                        sb.append("color:");
                        first = true;
                        for (Color c : effect.getColors()) {
                            if (!first) {
                                sb.append(",");
                            }
                            sb.append(c.toString());
                            first = false;
                        }
                        sb.append(" ");
                    }
                    sb.append("shape: ").append(effect.getType().name()).append(" ");
                    if (effect.getFadeColors() == null || effect.getFadeColors().isEmpty()) continue;
                    sb.append("fade:");
                    first = true;
                    for (Color c : effect.getFadeColors()) {
                        if (!first) {
                            sb.append(",");
                        }
                        sb.append(c.toString());
                        first = false;
                    }
                    sb.append(" ");
                }
                sb.append("power: ").append(fireworkMeta.getPower()).append(" ");
                break;
            }
            case POTION: {
                Potion potion = Potion.fromItemStack((ItemStack)is);
                for (PotionEffect e : potion.getEffects()) {
                    sb.append("effect:").append(e.getType().getName().toLowerCase()).append(" ").append("power:").append(e.getAmplifier()).append(" ").append("duration:").append(e.getDuration() / 20).append(" ");
                }
                break;
            }
            case SKULL_ITEM: {
                SkullMeta skullMeta = (SkullMeta)is.getItemMeta();
                if (skullMeta == null || !skullMeta.hasOwner()) break;
                sb.append("player:").append(skullMeta.getOwner()).append(" ");
                break;
            }
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)is.getItemMeta();
                int rgb = leatherArmorMeta.getColor().asRGB();
                sb.append("color:").append(rgb).append(" ");
                break;
            }
            case BANNER: {
                BannerMeta bannerMeta = (BannerMeta)is.getItemMeta();
                if (bannerMeta == null) break;
                int basecolor = bannerMeta.getBaseColor().getColor().asRGB();
                sb.append("basecolor:").append(basecolor).append(" ");
                for (org.bukkit.block.banner.Pattern p : bannerMeta.getPatterns()) {
                    String type = p.getPattern().getIdentifier();
                    int color = p.getColor().getColor().asRGB();
                    sb.append(type).append(",").append(color).append(" ");
                }
                break;
            }
        }
        return sb.toString().trim().replaceAll("\u00a7", "&");
    }

    class LengthCompare
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            return s1.length() - s2.length();
        }
    }

    static class ItemData {
        private final int itemNo;
        private final short itemData;

        ItemData(int itemNo, short itemData) {
            this.itemNo = itemNo;
            this.itemData = itemData;
        }

        public int getItemNo() {
            return this.itemNo;
        }

        public short getItemData() {
            return this.itemData;
        }

        public int hashCode() {
            return 31 * this.itemNo ^ this.itemData;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ItemData)) {
                return false;
            }
            ItemData pairo = (ItemData)o;
            return this.itemNo == pairo.getItemNo() && this.itemData == pairo.getItemData();
        }
    }
}

