/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class Backup
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private final transient Server server;
    private final transient IEssentials ess;
    private transient boolean running = false;
    private transient int taskId = -1;
    private transient boolean active = false;

    public Backup(IEssentials ess) {
        this.ess = ess;
        this.server = ess.getServer();
        if (!ess.getOnlinePlayers().isEmpty()) {
            ess.runTaskAsynchronously(new Runnable(){

                @Override
                public void run() {
                    Backup.this.startTask();
                }
            });
        }
    }

    public void onPlayerJoin() {
        this.startTask();
    }

    public synchronized void stopTask() {
        this.running = false;
        if (this.taskId != -1) {
            this.server.getScheduler().cancelTask(this.taskId);
        }
        this.taskId = -1;
    }

    private synchronized void startTask() {
        if (!this.running) {
            long interval = this.ess.getSettings().getBackupInterval() * 1200L;
            if (interval < 1200L) {
                return;
            }
            this.taskId = this.ess.scheduleSyncRepeatingTask(this, interval, interval);
            this.running = true;
        }
    }

    @Override
    public void run() {
        if (this.active) {
            return;
        }
        this.active = true;
        final String command = this.ess.getSettings().getBackupCommand();
        if (command == null || "".equals(command)) {
            return;
        }
        if ("save-all".equalsIgnoreCase(command)) {
            ConsoleCommandSender cs = this.server.getConsoleSender();
            this.server.dispatchCommand((CommandSender)cs, "save-all");
            this.active = false;
            return;
        }
        LOGGER.log(Level.INFO, I18n.tl("backupStarted", new Object[0]));
        ConsoleCommandSender cs = this.server.getConsoleSender();
        this.server.dispatchCommand((CommandSender)cs, "save-all");
        this.server.dispatchCommand((CommandSender)cs, "save-off");
        this.ess.runTaskAsynchronously(new Runnable((CommandSender)cs){
            final /* synthetic */ CommandSender val$cs;
            {
                this.val$cs = commandSender;
            }

            @Override
            public void run() {
                try {
                    ProcessBuilder childBuilder = new ProcessBuilder(command);
                    childBuilder.redirectErrorStream(true);
                    childBuilder.directory(Backup.this.ess.getDataFolder().getParentFile().getParentFile());
                    final Process child = childBuilder.start();
                    Backup.this.ess.runTaskAsynchronously(new Runnable(){

                        @Override
                        public void run() {
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(child.getInputStream()));){
                                String line;
                                do {
                                    if ((line = reader.readLine()) == null) continue;
                                    LOGGER.log(Level.INFO, line);
                                } while (line != null);
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.SEVERE, null, ex);
                            }
                        }
                    });
                    child.waitFor();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                finally {
                    class BackupEnableSaveTask
                    implements Runnable {
                        BackupEnableSaveTask() {
                        }

                        @Override
                        public void run() {
                            Backup.this.server.dispatchCommand(val$cs, "save-on");
                            if (Backup.this.ess.getOnlinePlayers().isEmpty()) {
                                Backup.this.stopTask();
                            }
                            Backup.this.active = false;
                            LOGGER.log(Level.INFO, I18n.tl("backupFinished", new Object[0]));
                        }
                    }
                    Backup.this.ess.scheduleSyncDelayedTask(new BackupEnableSaveTask());
                }
            }
        });
    }
}

