/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.data.vault;

import java.util.function.Function;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public abstract class VaultDataProvider<B, R>
implements Function<B, R> {
    @Override
    public final R apply(B b) {
        try {
            return this.apply0(b);
        }
        catch (Throwable th) {
            throw new RuntimeException("Exception while querying data from Vault\n" + this.getVaultInfo(), th);
        }
    }

    protected abstract R apply0(B var1);

    private String getVaultInfo() {
        StringBuilder info = new StringBuilder();
        Plugin vault = Bukkit.getPluginManager().getPlugin("Vault");
        if (vault != null) {
            info.append("Vault ").append(vault.getDescription().getVersion()).append("\n");
            try {
                this.addPermissionInfo(info);
            }
            catch (Throwable th) {
                info.append(th.toString());
            }
            try {
                this.addChatInfo(info);
            }
            catch (Throwable th) {
                info.append(th.toString());
            }
            try {
                this.addEconomyInfo(info);
            }
            catch (Throwable th) {
                info.append(th.toString());
            }
        }
        return info.toString();
    }

    private void addEconomyInfo(StringBuilder info) {
        Plugin plugin;
        Economy provider;
        RegisteredServiceProvider rsp2 = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp2 != null && (provider = (Economy)rsp2.getProvider()) != null && (plugin = Bukkit.getPluginManager().getPlugin(provider.getName())) != null) {
            info.append("Economy ").append(plugin.getDescription().getName()).append(" ").append(plugin.getDescription().getVersion()).append("\n");
        }
    }

    private void addChatInfo(StringBuilder info) {
        Plugin plugin;
        Chat provider;
        RegisteredServiceProvider rsp1 = Bukkit.getServicesManager().getRegistration(Chat.class);
        if (rsp1 != null && (provider = (Chat)rsp1.getProvider()) != null && (plugin = Bukkit.getPluginManager().getPlugin(provider.getName())) != null) {
            info.append("Chat ").append(plugin.getDescription().getName()).append(" ").append(plugin.getDescription().getVersion()).append("\n");
        }
    }

    private void addPermissionInfo(StringBuilder info) {
        Plugin plugin;
        Permission provider;
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Permission.class);
        if (rsp != null && (provider = (Permission)rsp.getProvider()) != null && (plugin = Bukkit.getPluginManager().getPlugin(provider.getName())) != null) {
            info.append("Permissions ").append(plugin.getDescription().getName()).append(" ").append(plugin.getDescription().getVersion()).append("\n");
        }
    }
}

