/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.data.permissionsex;

import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public abstract class PermissionsExDataProvider<B, R>
implements Function<B, R> {
    @Override
    public final R apply(B b) {
        try {
            return this.apply0(b);
        }
        catch (Throwable th) {
            throw new RuntimeException("Exception while querying data from PermissionsEx\n" + this.getPermissionsExInfo(), th);
        }
    }

    protected abstract R apply0(B var1);

    private String getPermissionsExInfo() {
        StringBuilder info = new StringBuilder();
        Plugin permissionsex = Bukkit.getPluginManager().getPlugin("PermissionsEx");
        if (permissionsex != null) {
            info.append("PermissionsEx ").append(permissionsex.getDescription().getVersion()).append("\n");
            try {
                this.addPermissionInfo(info);
            }
            catch (Throwable th) {
                info.append(th.toString());
            }
        }
        return info.toString();
    }

    private void addPermissionInfo(StringBuilder info) {
        Plugin plugin;
        Permission provider;
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Permission.class);
        if (rsp != null && (provider = (Permission)rsp.getProvider()) != null && (plugin = Bukkit.getPluginManager().getPlugin(provider.getName())) != null) {
            info.append("Permissions ").append(plugin.getDescription().getName()).append(" ").append(plugin.getDescription().getVersion()).append("\n");
        }
    }
}

