/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.data.bukkit;

import codecrafter47.bungeetablistplus.data.DataKeys;
import codecrafter47.bungeetablistplus.data.PermissionDataKey;
import codecrafter47.bungeetablistplus.data.bukkit.AbstractBukkitDataAccess;
import codecrafter47.bungeetablistplus.data.essentials.EssentialsIsAFKProvider;
import codecrafter47.bungeetablistplus.data.essentials.EssentialsIsVanishedProvider;
import codecrafter47.bungeetablistplus.data.factions.FactionNameProvider;
import codecrafter47.bungeetablistplus.data.factions.FactionPowerProvider;
import codecrafter47.bungeetablistplus.data.factions.FactionWhereProvider;
import codecrafter47.bungeetablistplus.data.factions.FactionsPlayerPowerProvider;
import codecrafter47.bungeetablistplus.data.factionsuuid.FactionMembersProvider;
import codecrafter47.bungeetablistplus.data.factionsuuid.FactionOnlineMembersProvider;
import codecrafter47.bungeetablistplus.data.factionsuuid.FactionPlayerPowerProvider;
import codecrafter47.bungeetablistplus.data.factionsuuid.FactionRankProvider;
import codecrafter47.bungeetablistplus.data.multiverse.MultiverseWorldAliasProvider;
import codecrafter47.bungeetablistplus.data.playerpoints.PlayerPointsProvider;
import codecrafter47.bungeetablistplus.data.simpleclans.SimpleClansClanColorTagProvider;
import codecrafter47.bungeetablistplus.data.simpleclans.SimpleClansClanNameProvider;
import codecrafter47.bungeetablistplus.data.simpleclans.SimpleClansClanTagLabelProvider;
import codecrafter47.bungeetablistplus.data.simpleclans.SimpleClansClanTagProvider;
import codecrafter47.bungeetablistplus.data.simpleclans.SimpleClansMembersProvider;
import codecrafter47.bungeetablistplus.data.simpleclans.SimpleClansOnlineClanMembersProvider;
import codecrafter47.bungeetablistplus.data.supervanish.SuperVanishIsVanishedProvider;
import codecrafter47.bungeetablistplus.data.vanishnopacket.VanishNoPacketIsVanishedProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultBalanceProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultGroupProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultGroupRankProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultGroupWeightProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultPlayerPrefixProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultPrefixProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultPrimaryGroupPrefixProvider;
import codecrafter47.bungeetablistplus.data.vault.VaultSuffixProvider;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;

public class PlayerDataAccess
extends AbstractBukkitDataAccess<Player> {
    private final Plugin plugin;

    public PlayerDataAccess(Plugin plugin) {
        super(plugin.getLogger(), plugin);
        this.plugin = plugin;
        this.init();
    }

    protected void init() {
        this.bind(DataKeys.Health, Damageable::getHealth);
        this.bind(DataKeys.Level, Player::getLevel);
        this.bind(DataKeys.MaxHealth, Damageable::getMaxHealth);
        this.bind(DataKeys.XP, Player::getExp);
        this.bind(DataKeys.TotalXP, Player::getTotalExperience);
        this.bind(DataKeys.PosX, (B player) -> player.getLocation().getX());
        this.bind(DataKeys.PosY, (B player) -> player.getLocation().getY());
        this.bind(DataKeys.PosZ, (B player) -> player.getLocation().getZ());
        this.bind(DataKeys.Team, (B player) -> {
            Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
            return team != null ? team.getName() : null;
        });
        this.bind(PermissionDataKey.class, (B player, K key) -> {
            try {
                return player.hasPermission(key.getPermission());
            }
            catch (Throwable ignored) {
                return null;
            }
        });
        this.bind(DataKeys.DisplayName, Player::getDisplayName);
        this.bind(DataKeys.PlayerListName, Player::getPlayerListName);
        this.bind(DataKeys.World, (B player) -> player.getWorld().getName());
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            this.bind(DataKeys.Vault_Balance, new VaultBalanceProvider(this.plugin));
            this.bind(DataKeys.Vault_PermissionGroup, new VaultGroupProvider());
            this.bind(DataKeys.Vault_PermissionGroupWeight, new VaultGroupWeightProvider());
            this.bind(DataKeys.Vault_PermissionGroupRank, new VaultGroupRankProvider());
            this.bind(DataKeys.Vault_Prefix, new VaultPrefixProvider());
            this.bind(DataKeys.Vault_Suffix, new VaultSuffixProvider());
            this.bind(DataKeys.Vault_PrimaryGroupPrefix, new VaultPrimaryGroupPrefixProvider());
            this.bind(DataKeys.Vault_PlayerPrefix, new VaultPlayerPrefixProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("VanishNoPacket") != null) {
            this.bind(DataKeys.VanishNoPacket_IsVanished, new VanishNoPacketIsVanishedProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
            this.bind(DataKeys.PlayerPoints_Points, new PlayerPointsProvider(this.logger));
        }
        if (Bukkit.getPluginManager().getPlugin("Factions") != null) {
            if (PlayerDataAccess.classExists("com.massivecraft.factions.FPlayer")) {
                this.bind(DataKeys.Factions_FactionName, new codecrafter47.bungeetablistplus.data.factionsuuid.FactionNameProvider());
                this.bind(DataKeys.Factions_FactionMembers, new FactionMembersProvider());
                this.bind(DataKeys.Factions_FactionPower, new codecrafter47.bungeetablistplus.data.factionsuuid.FactionPowerProvider());
                this.bind(DataKeys.Factions_FactionsRank, new FactionRankProvider());
                this.bind(DataKeys.Factions_FactionsWhere, new codecrafter47.bungeetablistplus.data.factionsuuid.FactionWhereProvider());
                this.bind(DataKeys.Factions_OnlineFactionMembers, new FactionOnlineMembersProvider());
                this.bind(DataKeys.Factions_PlayerPower, new FactionPlayerPowerProvider());
            } else if (PlayerDataAccess.classExists("com.massivecraft.factions.entity.MPlayer")) {
                this.bind(DataKeys.Factions_FactionName, new FactionNameProvider());
                this.bind(DataKeys.Factions_FactionMembers, new codecrafter47.bungeetablistplus.data.factions.FactionMembersProvider());
                this.bind(DataKeys.Factions_FactionPower, new FactionPowerProvider());
                this.bind(DataKeys.Factions_FactionsRank, new codecrafter47.bungeetablistplus.data.factions.FactionRankProvider());
                this.bind(DataKeys.Factions_FactionsWhere, new FactionWhereProvider());
                this.bind(DataKeys.Factions_OnlineFactionMembers, new codecrafter47.bungeetablistplus.data.factions.FactionOnlineMembersProvider());
                this.bind(DataKeys.Factions_PlayerPower, new FactionsPlayerPowerProvider());
            } else {
                this.logger.warning("Unable to recognize your Factions version. Factions support is disabled. Please contact the plugin developer to request support for your Factions version (" + Bukkit.getPluginManager().getPlugin("Factions").getDescription().getVersion() + ").");
            }
        }
        if (Bukkit.getPluginManager().getPlugin("SuperVanish") != null || Bukkit.getPluginManager().getPlugin("PremiumVanish") != null) {
            this.bind(DataKeys.SuperVanish_IsVanished, new SuperVanishIsVanishedProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("SimpleClans") != null) {
            this.bind(DataKeys.SimpleClans_ClanName, new SimpleClansClanNameProvider());
            this.bind(DataKeys.SimpleClans_ClanMembers, new SimpleClansMembersProvider());
            this.bind(DataKeys.SimpleClans_OnlineClanMembers, new SimpleClansOnlineClanMembersProvider());
            this.bind(DataKeys.SimpleClans_ClanTag, new SimpleClansClanTagProvider());
            this.bind(DataKeys.SimpleClans_ClanTagLabel, new SimpleClansClanTagLabelProvider());
            this.bind(DataKeys.SimpleClans_ClanColorTag, new SimpleClansClanColorTagProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
            this.bind(DataKeys.Essentials_IsVanished, new EssentialsIsVanishedProvider());
            this.bind(DataKeys.Essentials_IsAFK, new EssentialsIsAFKProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("Multiverse-Core") != null) {
            this.bind(DataKeys.Multiverse_WorldAlias, new MultiverseWorldAliasProvider());
        }
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

