/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;

public class DataKey<T>
implements Serializable {
    private final String id;
    private final Scope scope;
    private final boolean bungee;
    private static final long serialVersionUID = 1L;

    public static DataKeyBuilder builder() {
        return new DataKeyBuilder();
    }

    protected DataKey(String id, Scope scope, boolean bungee) {
        this.id = id;
        this.scope = scope;
        this.bungee = bungee;
    }

    public String getId() {
        return this.id;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isBungee() {
        return this.bungee;
    }

    public int hashCode() {
        return this.id.hashCode() + this.scope.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DataKey && this.getId().equals(((DataKey)obj).getId()) && this.getScope().equals((Object)((DataKey)obj).getScope());
    }

    public String toString() {
        return this.getId();
    }

    public static class DataKeyBuilder {
        private String id = null;
        private Scope scope = null;
        private Boolean bungee = null;

        private DataKeyBuilder() {
        }

        public DataKeyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DataKeyBuilder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public DataKeyBuilder server() {
            return this.scope(Scope.SERVER);
        }

        public DataKeyBuilder player() {
            return this.scope(Scope.PLAYER);
        }

        public DataKeyBuilder bukkit() {
            this.bungee = false;
            return this;
        }

        public DataKeyBuilder bungee() {
            this.bungee = true;
            return this;
        }

        public <T> DataKey<T> build() {
            Preconditions.checkNotNull((Object)this.id, (Object)"id");
            Preconditions.checkNotNull((Object)((Object)this.scope), (Object)"scope");
            Preconditions.checkNotNull((Object)this.bungee, (Object)"bungee");
            return new DataKey(this.id, this.scope, this.bungee);
        }
    }

    public static enum Scope {
        PLAYER,
        SERVER;

    }
}

