/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.concurrent.Executor;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class BugReportingService {
    private final Level level;
    private final String pluginName;
    private final String pluginVersion;
    private final Executor executor;
    private final String systemInfo;
    private final BugReportFormatter formatter = new BugReportFormatter();

    public BugReportingService(Level level, String pluginName, String pluginVersion, Executor executor, String systemInfo) {
        this.level = level;
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.executor = executor;
        this.systemInfo = systemInfo;
    }

    public void registerLogger(Logger logger) {
        UploadBugReportHandler handler = new UploadBugReportHandler();
        handler.setLevel(this.level);
        handler.setFormatter(this.formatter);
        logger.addHandler(handler);
        handler.setLevel(this.level);
        handler.setFormatter(this.formatter);
    }

    public void unregisterLogger(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof UploadBugReportHandler)) continue;
            logger.removeHandler(handler);
        }
    }

    private static class BugReportFormatter
    extends Formatter {
        private BugReportFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder formatted = new StringBuilder();
            formatted.append(this.formatMessage(record));
            formatted.append('\n');
            if (record.getThrown() != null) {
                StringWriter writer = new StringWriter();
                record.getThrown().printStackTrace(new PrintWriter(writer));
                formatted.append(writer);
            }
            return formatted.toString();
        }
    }

    private class UploadBugReportHandler
    extends Handler {
        int reportedBugs = 0;

        private UploadBugReportHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (record.getLevel().intValue() >= BugReportingService.this.level.intValue() && this.reportedBugs++ < 10) {
                BugReportingService.this.executor.execute(() -> {
                    try {
                        String url = String.format("http://bugs.codecrafter47.dyndns.eu/?plugin=%s&version=%s&message=%s", URLEncoder.encode(BugReportingService.this.pluginName, "UTF-8"), URLEncoder.encode(BugReportingService.this.pluginVersion, "UTF-8"), URLEncoder.encode(this.getFormatter().format(record) + "\n\n" + BugReportingService.this.systemInfo, "UTF-8"));
                        URLConnection connection = new URL(url).openConnection();
                        connection.connect();
                        connection.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

