/*
 * Decompiled with CFR 0.152.
 */
package codecrafter47.bungeetablistplus.common;

import codecrafter47.bungeetablistplus.data.DataKey;
import java.util.List;

public final class BTLPDataKeys {
    public static final DataKey<List<String>> REGISTERED_THIRD_PARTY_VARIABLES = DataKey.builder().bukkit().server().id("thirdparty-variables").build();
    public static final DataKey<Boolean> PLACEHOLDERAPI_PRESENT = DataKey.builder().bukkit().server().id("placeholderapi-present").build();

    public static PlaceholderAPIDataKey createPlaceholderAPIDataKey(String placeholder) {
        return new PlaceholderAPIDataKey(placeholder);
    }

    public static ThirdPartyVariableDataKey createThirdPartyVariableDataKey(String name) {
        return new ThirdPartyVariableDataKey(name);
    }

    public static class ThirdPartyVariableDataKey
    extends DataKey<String> {
        private final String name;
        private static final long serialVersionUID = 1L;

        private ThirdPartyVariableDataKey(String name) {
            super("thirdparty", DataKey.Scope.PLAYER, false);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.name.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof ThirdPartyVariableDataKey && ((ThirdPartyVariableDataKey)obj).name.equals(this.name);
        }

        @Override
        public String toString() {
            return super.toString() + ":" + this.name;
        }
    }

    public static class PlaceholderAPIDataKey
    extends DataKey<String> {
        private final String placeholder;
        private static final long serialVersionUID = 1L;

        private PlaceholderAPIDataKey(String placeholder) {
            super("placeholderAPI", DataKey.Scope.PLAYER, false);
            this.placeholder = placeholder;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.placeholder.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PlaceholderAPIDataKey && ((PlaceholderAPIDataKey)obj).placeholder.equals(this.placeholder);
        }

        @Override
        public String toString() {
            return super.toString() + ":" + this.placeholder;
        }
    }
}

