/*
 * Decompiled with CFR 0.152.
 */
package fr.manercraft.jumppad;

import fr.manercraft.jumppad.PlayerMove;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.gravitydevelopment.updater.Updater;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    public static YamlConfiguration LANG;
    public static File LANG_FILE;
    private Logger log = Logger.getLogger("Minecraft");

    public void onEnable() {
        System.out.println("[JumpPad] Plugin load");
        System.out.println("[JumpPad] By Manercraft");
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new PlayerMove(this), (Plugin)this);
        Updater updater = new Updater((Plugin)this, 93625, this.getFile(), Updater.UpdateType.DEFAULT, false);
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (this.getConfig().getDouble("version_config") != 0.2) {
            configFile.delete();
            this.saveDefaultConfig();
            this.reloadConfig();
        }
        this.saveDefaultConfig();
        this.loadLang();
    }

    public void onDisable() {
        this.reloadConfig();
        System.out.println("[JumpPad] Plugin unload");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String[] arg = args;
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (cmd.getName().equalsIgnoreCase("jumppad")) {
                if (args.length < 1) {
                    p.sendMessage(Lang.TITLE.toString());
                    p.sendMessage(ChatColor.RED + "Plugin by Manercraft");
                    p.sendMessage(ChatColor.GOLD + "Commands:");
                    p.sendMessage(ChatColor.RED + "/jumppad reload");
                    p.sendMessage(ChatColor.RED + "/jumppad info");
                    p.sendMessage(ChatColor.GOLD + "Version " + this.getDescription().getVersion());
                    return false;
                }
                if (arg[0].equalsIgnoreCase("info")) {
                    if (p.hasPermission("jumppad.info")) {
                        String structureFirstMaterial = this.getConfig().getString("Structure.First.Material");
                        String structureSecondMaterial = this.getConfig().getString("Structure.Second.Material");
                        String structureThirdMaterial = this.getConfig().getString("Structure.Third.Material");
                        String effect = this.getConfig().getString("Effect");
                        String powerMultiply = this.getConfig().getString("Power.Multiply");
                        String powerLocY = this.getConfig().getString("Power.LocY");
                        String soundSound = this.getConfig().getString("Sound.Sound");
                        String soundVolume = this.getConfig().getString("Sound.Volume");
                        String soundPitch = this.getConfig().getString("Sound.Pitch");
                        Boolean noFallDamage = this.getConfig().getBoolean("No_Fall_Damage");
                        p.sendMessage(Lang.TITLE.toString());
                        p.sendMessage(ChatColor.GREEN + "First block: " + structureFirstMaterial);
                        p.sendMessage(ChatColor.GOLD + "Second block: " + structureSecondMaterial);
                        p.sendMessage(ChatColor.GREEN + "Third block: " + structureThirdMaterial);
                        p.sendMessage("");
                        p.sendMessage(ChatColor.GOLD + "Effect: " + effect);
                        p.sendMessage("");
                        p.sendMessage(ChatColor.GREEN + "Power Multiply: " + powerMultiply);
                        p.sendMessage(ChatColor.GOLD + "Power LocY: " + powerLocY);
                        p.sendMessage("");
                        p.sendMessage(ChatColor.GREEN + "Sound: " + soundSound);
                        p.sendMessage(ChatColor.GOLD + "Volume: " + soundVolume);
                        p.sendMessage(ChatColor.GREEN + "Pitch: " + soundPitch);
                        p.sendMessage("");
                        p.sendMessage(ChatColor.GOLD + "No Fall Damage: " + noFallDamage);
                        return true;
                    }
                    p.sendMessage(Lang.TITLE.toString());
                    p.sendMessage(Lang.NO_PERMS.toString());
                    return false;
                }
                if (arg[0].equalsIgnoreCase("reload")) {
                    if (p.hasPermission("jumppad.reload")) {
                        this.reloadConfig();
                        p.sendMessage(Lang.TITLE.toString());
                        p.sendMessage(ChatColor.GREEN + "Config reloaded !");
                        return true;
                    }
                    p.sendMessage(Lang.TITLE.toString());
                    p.sendMessage(Lang.NO_PERMS.toString());
                    return false;
                }
                return false;
            }
            return false;
        }
        this.log.log(Level.SEVERE, Lang.TITLE.toString());
        this.log.log(Level.SEVERE, Lang.Should_be_player.toString());
        return false;
    }

    public void loadLang() {
        File lang = new File(this.getDataFolder(), "lang.yml");
        if (!lang.exists()) {
            try {
                this.getDataFolder().mkdir();
                lang.createNewFile();
                InputStream defConfigStream = this.getResource("lang.yml");
                if (defConfigStream != null) {
                    YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
                    defConfig.save(lang);
                    Lang.setFile(defConfig);
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.log.log(Level.INFO, "[JumpPad] EN:");
                this.log.severe("[JumpPad] Couldn't create language file.");
                this.log.severe("[JumpPad] This is a fatal error. Now disabling");
                this.log.log(Level.INFO, "[JumpPad] FR:");
                this.log.severe("[JumpPad] Erreur a la creation du fichier de langue.");
                this.log.severe("[JumpPad] Erreur fatal. Desactivation");
                this.setEnabled(false);
            }
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)lang);
        Lang[] langArray = Lang.values();
        int n = langArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lang item = langArray[n2];
            if (conf.getString(item.getPath()) == null) {
                conf.set(item.getPath(), (Object)item.getDefault());
            }
            ++n2;
        }
        Lang.setFile(conf);
        LANG = conf;
        LANG_FILE = lang;
        try {
            conf.save(this.getLangFile());
        }
        catch (IOException e) {
            this.log.log(Level.INFO, "[JumpPad] EN:");
            this.log.log(Level.WARNING, "[JumpPad] Failed to save lang.yml.");
            this.log.log(Level.WARNING, "[JumpPad] Report this stack trace to Manercraft.");
            this.log.log(Level.INFO, "[JumpPad] FR:");
            this.log.log(Level.WARNING, "[JumpPad] Impossible de sauvegarder lang.yml.");
            this.log.log(Level.WARNING, "[JumpPad] Merci de report ce bug a Manercraft.");
            e.printStackTrace();
        }
    }

    public YamlConfiguration getLang() {
        return LANG;
    }

    public File getLangFile() {
        return LANG_FILE;
    }

    public static enum Lang {
        TITLE("prefix", "&4--- [&bJumpPad&4] ---"),
        NO_PERMS("no-permissions", "&cYou don't have permission for that!"),
        Should_be_player("should_be_player", "&cYou should be a player!");

        private String path;
        private String def;
        private static YamlConfiguration LANG;

        private Lang(String path, String start) {
            this.path = path;
            this.def = start;
        }

        public static void setFile(YamlConfiguration config) {
            LANG = config;
        }

        public String toString() {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)LANG.getString(this.path, this.def));
        }

        public String getDefault() {
            return this.def;
        }

        public String getPath() {
            return this.path;
        }
    }
}

