/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.collection;

import com.comphenix.protocol.wrappers.collection.AbstractConverted;
import com.comphenix.protocol.wrappers.collection.BiFunction;
import com.comphenix.protocol.wrappers.collection.ConvertedSet;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class ConvertedMap<Key, VInner, VOuter>
extends AbstractConverted<VInner, VOuter>
implements Map<Key, VOuter> {
    private Map<Key, VInner> inner;
    private BiFunction<Key, VOuter, VInner> innerConverter = new BiFunction<Key, VOuter, VInner>(){

        @Override
        public VInner apply(Key key, VOuter outer) {
            return ConvertedMap.this.toInner(key, outer);
        }
    };
    private BiFunction<Key, VInner, VOuter> outerConverter = new BiFunction<Key, VInner, VOuter>(){

        @Override
        public VOuter apply(Key key, VInner inner) {
            return ConvertedMap.this.toOuter(key, inner);
        }
    };

    public ConvertedMap(Map<Key, VInner> inner) {
        if (inner == null) {
            throw new IllegalArgumentException("Inner map cannot be NULL.");
        }
        this.inner = inner;
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inner.containsValue(this.toInner(value));
    }

    @Override
    public Set<Map.Entry<Key, VOuter>> entrySet() {
        return ConvertedMap.convertedEntrySet(this.inner.entrySet(), this.innerConverter, this.outerConverter);
    }

    protected VOuter toOuter(Key key, VInner inner) {
        return this.toOuter(inner);
    }

    protected VInner toInner(Key key, VOuter outer) {
        return this.toInner(outer);
    }

    @Override
    public VOuter get(Object key) {
        return this.toOuter(key, this.inner.get(key));
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public Set<Key> keySet() {
        return this.inner.keySet();
    }

    @Override
    public VOuter put(Key key, VOuter value) {
        return this.toOuter(key, this.inner.put(key, this.toInner(key, value)));
    }

    @Override
    public void putAll(Map<? extends Key, ? extends VOuter> m) {
        for (Map.Entry<Key, VOuter> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public VOuter remove(Object key) {
        return this.toOuter(key, this.inner.remove(key));
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public Collection<VOuter> values() {
        return Collections2.transform(this.entrySet(), (Function)new Function<Map.Entry<Key, VOuter>, VOuter>(){

            public VOuter apply(@Nullable Map.Entry<Key, VOuter> entry) {
                return entry.getValue();
            }
        });
    }

    public String toString() {
        Iterator<Map.Entry<Key, VOuter>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<Key, VOuter> e = i.next();
            Key key = e.getKey();
            VOuter value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    static <Key, VInner, VOuter> Set<Map.Entry<Key, VOuter>> convertedEntrySet(Collection<Map.Entry<Key, VInner>> entries, final BiFunction<Key, VOuter, VInner> innerFunction, final BiFunction<Key, VInner, VOuter> outerFunction) {
        return new ConvertedSet<Map.Entry<Key, VInner>, Map.Entry<Key, VOuter>>(entries){

            @Override
            protected Map.Entry<Key, VInner> toInner(final Map.Entry<Key, VOuter> outer) {
                return new Map.Entry<Key, VInner>(){

                    @Override
                    public Key getKey() {
                        return outer.getKey();
                    }

                    @Override
                    public VInner getValue() {
                        return innerFunction.apply(this.getKey(), outer.getValue());
                    }

                    @Override
                    public VInner setValue(VInner value) {
                        return innerFunction.apply(this.getKey(), outer.setValue(outerFunction.apply(this.getKey(), value)));
                    }

                    public String toString() {
                        return String.format("\"%s\": %s", this.getKey(), this.getValue());
                    }
                };
            }

            @Override
            protected Map.Entry<Key, VOuter> toOuter(final Map.Entry<Key, VInner> inner) {
                return new Map.Entry<Key, VOuter>(){

                    @Override
                    public Key getKey() {
                        return inner.getKey();
                    }

                    @Override
                    public VOuter getValue() {
                        return outerFunction.apply(this.getKey(), inner.getValue());
                    }

                    @Override
                    public VOuter setValue(VOuter value) {
                        Object converted = innerFunction.apply(this.getKey(), value);
                        return outerFunction.apply(this.getKey(), inner.setValue(converted));
                    }

                    public String toString() {
                        return String.format("\"%s\": %s", this.getKey(), this.getValue());
                    }
                };
            }
        };
    }
}

