/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.collection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class CachedCollection<T>
implements Collection<T> {
    protected Set<T> delegate;
    protected Object[] cache;

    public CachedCollection(Set<T> delegate) {
        this.delegate = (Set)Preconditions.checkNotNull(delegate, (Object)"delegate cannot be NULL.");
    }

    private void initializeCache() {
        if (this.cache == null) {
            this.cache = new Object[this.delegate.size()];
        }
    }

    private void growCache() {
        int newLength;
        if (this.cache == null) {
            return;
        }
        for (newLength = this.cache.length; newLength < this.delegate.size(); newLength *= 2) {
        }
        if (newLength != this.cache.length) {
            this.cache = Arrays.copyOf(this.cache, newLength);
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> source = this.delegate.iterator();
        this.initializeCache();
        return new Iterator<T>(){
            int currentIndex = -1;
            int iteratorIndex = -1;

            @Override
            public boolean hasNext() {
                return this.currentIndex < CachedCollection.this.delegate.size() - 1;
            }

            @Override
            public T next() {
                ++this.currentIndex;
                if (CachedCollection.this.cache[this.currentIndex] == null) {
                    CachedCollection.this.cache[this.currentIndex] = this.getSourceValue();
                }
                return CachedCollection.this.cache[this.currentIndex];
            }

            @Override
            public void remove() {
                this.getSourceValue();
                source.remove();
            }

            private T getSourceValue() {
                Object last = null;
                while (this.iteratorIndex < this.currentIndex) {
                    ++this.iteratorIndex;
                    last = source.next();
                }
                return last;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Iterators.size(this.iterator());
        return (Object[])this.cache.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Iterators.size(this.iterator());
        return Arrays.copyOf(this.cache, this.size(), a.getClass().getComponentType());
    }

    @Override
    public boolean add(T e) {
        boolean result = this.delegate.add(e);
        this.growCache();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = this.delegate.addAll(c);
        this.growCache();
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        this.cache = null;
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.cache = null;
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.cache = null;
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.cache = null;
        this.delegate.clear();
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (T element : this) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public String toString() {
        Iterators.size(this.iterator());
        StringBuilder result = new StringBuilder("[");
        for (T element : this) {
            if (result.length() > 1) {
                result.append(", ");
            }
            result.append(element);
        }
        return result.append("]").toString();
    }
}

