/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.WrappedChunkCoordinate;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.collection.ConvertedMap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class WrappedDataWatcher
extends AbstractWrapper
implements Iterable<WrappedWatchableObject> {
    private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherClass();
    private static MethodAccessor GETTER = null;
    private static MethodAccessor SETTER = null;
    private static MethodAccessor REGISTER = null;
    private static FieldAccessor ENTITY_DATA_FIELD = null;
    private static FieldAccessor ENTITY_FIELD = null;
    private static FieldAccessor MAP_FIELD = null;
    private static ConstructorAccessor constructor = null;
    private static ConstructorAccessor lightningConstructor = null;
    private static Object fakeEntity = null;

    public WrappedDataWatcher(Object handle) {
        super(HANDLE_TYPE);
        this.setHandle(handle);
    }

    public WrappedDataWatcher() {
        this(WrappedDataWatcher.newHandle(WrappedDataWatcher.fakeEntity()));
    }

    public WrappedDataWatcher(Entity entity) {
        this(WrappedDataWatcher.newHandle(BukkitUnwrapper.getInstance().unwrapItem(entity)));
    }

    public WrappedDataWatcher(List<WrappedWatchableObject> objects) {
        this();
        for (WrappedWatchableObject object : objects) {
            this.setObject(object.getWatcherObject(), object);
        }
    }

    private static Object newHandle(Object entity) {
        if (constructor == null) {
            constructor = Accessors.getConstructorAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass());
        }
        return constructor.invoke(entity);
    }

    private static Object fakeEntity() {
        if (fakeEntity != null) {
            return fakeEntity;
        }
        if (lightningConstructor == null) {
            lightningConstructor = Accessors.getConstructorAccessor(MinecraftReflection.getMinecraftClass("EntityLightning"), MinecraftReflection.getNmsWorldClass(), Double.TYPE, Double.TYPE, Double.TYPE, Boolean.TYPE);
        }
        fakeEntity = lightningConstructor.invoke(null, 0, 0, 0, true);
        return fakeEntity;
    }

    private Map<Integer, Object> getMap() {
        if (MAP_FIELD == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
            MAP_FIELD = Accessors.getFieldAccessor(fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).typeDerivedOf(Map.class).build()));
        }
        if (MAP_FIELD == null) {
            throw new FieldAccessException("Could not find index <-> Item map.");
        }
        return (Map)MAP_FIELD.get(this.handle);
    }

    public Map<Integer, WrappedWatchableObject> asMap() {
        return new ConvertedMap<Integer, Object, WrappedWatchableObject>(this.getMap()){

            @Override
            protected WrappedWatchableObject toOuter(Object inner) {
                return inner != null ? new WrappedWatchableObject(inner) : null;
            }

            @Override
            protected Object toInner(WrappedWatchableObject outer) {
                return outer != null ? outer.getHandle() : null;
            }
        };
    }

    public Set<Integer> getIndexes() {
        return this.getMap().keySet();
    }

    public List<WrappedWatchableObject> getWatchableObjects() {
        return new ArrayList<WrappedWatchableObject>(this.asMap().values());
    }

    @Override
    public Iterator<WrappedWatchableObject> iterator() {
        return this.getWatchableObjects().iterator();
    }

    public int size() {
        return this.getMap().size();
    }

    public WrappedWatchableObject getWatchableObject(int index) {
        Object handle = this.getMap().get(index);
        if (handle != null) {
            return new WrappedWatchableObject(handle);
        }
        return null;
    }

    public WrappedWatchableObject remove(int index) {
        Object removed = this.getMap().remove(index);
        return removed != null ? new WrappedWatchableObject(removed) : null;
    }

    public boolean hasIndex(int index) {
        return this.getMap().containsKey(index);
    }

    public void clear() {
        this.getMap().clear();
    }

    public Byte getByte(int index) {
        return (Byte)this.getObject(index);
    }

    public Short getShort(int index) {
        return (Short)this.getObject(index);
    }

    public Integer getInteger(int index) {
        return (Integer)this.getObject(index);
    }

    public Float getFloat(int index) {
        return (Float)this.getObject(index);
    }

    public String getString(int index) {
        return (String)this.getObject(index);
    }

    public ItemStack getItemStack(int index) {
        return (ItemStack)this.getObject(index);
    }

    public WrappedChunkCoordinate getChunkCoordinate(int index) {
        return (WrappedChunkCoordinate)this.getObject(index);
    }

    public Object getObject(int index) {
        return this.getObject(new WrappedDataWatcherObject(index, null));
    }

    public Object getObject(WrappedDataWatcherObject object) {
        Validate.notNull((Object)object, (String)"Watcher object cannot be null!");
        if (GETTER == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType);
            GETTER = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactType(object.getHandleType()).returnTypeExact(Object.class).build(), "get"));
        }
        Object value = GETTER.invoke(this.handle, object.getHandle());
        return WrappedWatchableObject.getWrapped(value);
    }

    public void setObject(int index, Object value) {
        Validate.isTrue((boolean)this.hasIndex(index), (String)"You cannot register objects without the watcher object!");
        this.setObject(index, null, value);
    }

    public void setObject(int index, Serializer serializer, Object value) {
        this.setObject(new WrappedDataWatcherObject(index, serializer), value);
    }

    public void setObject(WrappedDataWatcherObject object, WrappedWatchableObject value) {
        this.setObject(object, value.getRawValue());
    }

    public void setObject(WrappedDataWatcherObject object, Object value) {
        Validate.notNull((Object)object, (String)"Watcher object cannot be null!");
        if (SETTER == null || REGISTER == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
            FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().banModifier(8).requireModifier(1).parameterExactArray(object.getHandleType(), Object.class).build();
            SETTER = Accessors.getMethodAccessor(fuzzy.getMethod(contract, "set"));
            REGISTER = Accessors.getMethodAccessor(fuzzy.getMethod(contract, "register"));
        }
        if (this.hasIndex(object.getIndex())) {
            SETTER.invoke(this.handle, object.getHandle(), WrappedWatchableObject.getUnwrapped(value));
        } else {
            Serializer serializer = object.getSerializer();
            Validate.notNull((Object)serializer, (String)"You must specify a serializer to register an object!");
            REGISTER.invoke(this.handle, object.getHandle(), WrappedWatchableObject.getUnwrapped(value));
        }
    }

    public WrappedDataWatcher deepClone() {
        WrappedDataWatcher clone = new WrappedDataWatcher(this.getEntity());
        for (WrappedWatchableObject wrapper : this) {
            clone.setObject(wrapper.getWatcherObject(), wrapper);
        }
        return clone;
    }

    public static WrappedDataWatcher getEntityWatcher(Entity entity) {
        BukkitUnwrapper unwrapper;
        Object handle;
        if (ENTITY_DATA_FIELD == null) {
            ENTITY_DATA_FIELD = Accessors.getFieldAccessor(MinecraftReflection.getEntityClass(), MinecraftReflection.getDataWatcherClass(), true);
        }
        return (handle = ENTITY_DATA_FIELD.get((unwrapper = new BukkitUnwrapper()).unwrapItem(entity))) != null ? new WrappedDataWatcher(handle) : null;
    }

    public Entity getEntity() {
        if (ENTITY_FIELD == null) {
            ENTITY_FIELD = Accessors.getFieldAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass(), true);
        }
        return (Entity)MinecraftReflection.getBukkitEntity(ENTITY_FIELD.get(this.handle));
    }

    public void setEntity(Entity entity) {
        if (ENTITY_FIELD == null) {
            ENTITY_FIELD = Accessors.getFieldAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass(), true);
        }
        ENTITY_FIELD.set(this.handle, BukkitUnwrapper.getInstance().unwrapItem(entity));
    }

    @Deprecated
    public static Integer getTypeID(Class<?> clazz) {
        return null;
    }

    @Deprecated
    public static Class<?> getTypeClass(int typeID) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedDataWatcher) {
            WrappedDataWatcher other = (WrappedDataWatcher)obj;
            Iterator<WrappedWatchableObject> first = this.iterator();
            Iterator<WrappedWatchableObject> second = other.iterator();
            if (this.size() != other.size()) {
                return false;
            }
            while (first.hasNext() && second.hasNext()) {
                if (first.next().equals(second.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getWatchableObjects().hashCode();
    }

    public String toString() {
        return "WrappedDataWatcher[handle=" + this.handle + "]";
    }

    public static class Registry {
        private static boolean INITIALIZED = false;
        private static List<Serializer> REGISTRY = new ArrayList<Serializer>();

        public static Serializer get(Class<?> clazz) {
            Validate.notNull((Object)"Class cannot be null!");
            Registry.initialize();
            for (Serializer serializer : REGISTRY) {
                if (!serializer.getType().equals(clazz)) continue;
                return serializer;
            }
            return null;
        }

        public static Serializer get(Class<?> clazz, boolean optional) {
            Validate.notNull(clazz, (String)"Class cannot be null!");
            Registry.initialize();
            for (Serializer serializer : REGISTRY) {
                if (!serializer.getType().equals(clazz) || serializer.isOptional() != optional) continue;
                return serializer;
            }
            return null;
        }

        public static Serializer fromHandle(Object handle) {
            Validate.notNull((Object)"Handle cannot be null!");
            Registry.initialize();
            for (Serializer serializer : REGISTRY) {
                if (!serializer.getHandle().equals(handle)) continue;
                return serializer;
            }
            return null;
        }

        private static void initialize() {
            if (INITIALIZED) {
                return;
            }
            INITIALIZED = true;
            List<Field> candidates = FuzzyReflection.fromClass(MinecraftReflection.getDataWatcherRegistryClass(), true).getFieldListByType(MinecraftReflection.getDataWatcherSerializerClass());
            for (Field candidate : candidates) {
                Object serializer;
                Type generic = candidate.getGenericType();
                if (!(generic instanceof ParameterizedType)) continue;
                ParameterizedType type = (ParameterizedType)generic;
                Type[] args = type.getActualTypeArguments();
                Type arg = args[0];
                Class innerClass = null;
                boolean optional = false;
                if (arg instanceof Class) {
                    innerClass = (Class)arg;
                } else if (arg instanceof ParameterizedType) {
                    innerClass = (Class)((ParameterizedType)arg).getActualTypeArguments()[0];
                    optional = true;
                } else {
                    throw new IllegalStateException("Failed to find inner class of field " + candidate);
                }
                try {
                    serializer = candidate.get(null);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Failed to read field " + candidate);
                }
                REGISTRY.add(new Serializer(innerClass, serializer, optional));
            }
        }
    }

    public static class Serializer
    extends AbstractWrapper {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherSerializerClass();
        private final Class<?> type;
        private final boolean optional;

        public Serializer(Class<?> type, Object handle, boolean optional) {
            super(HANDLE_TYPE);
            this.type = type;
            this.optional = optional;
            this.setHandle(handle);
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "Serializer[type=" + this.type + ", handle=" + this.handle + ", optional=" + this.optional + "]";
        }
    }

    public static class WrappedDataWatcherObject
    extends AbstractWrapper {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherObjectClass();
        private static ConstructorAccessor constructor = null;
        private static MethodAccessor getSerializer = null;
        private final StructureModifier<Object> modifier;

        public WrappedDataWatcherObject(Object handle) {
            super(HANDLE_TYPE);
            this.setHandle(handle);
            this.modifier = new StructureModifier(HANDLE_TYPE).withTarget(handle);
        }

        public WrappedDataWatcherObject(int index, Serializer serializer) {
            this(WrappedDataWatcherObject.newHandle(index, serializer));
        }

        private static Object newHandle(int index, Serializer serializer) {
            if (constructor == null) {
                constructor = Accessors.getConstructorAccessor(HANDLE_TYPE.getConstructors()[0]);
            }
            Object handle = serializer != null ? serializer.getHandle() : null;
            return constructor.invoke(index, handle);
        }

        public int getIndex() {
            return (Integer)this.modifier.read(0);
        }

        public Serializer getSerializer() {
            Object serializer;
            if (getSerializer == null) {
                getSerializer = Accessors.getMethodAccessor(FuzzyReflection.fromClass(HANDLE_TYPE, true).getMethodByParameters("getSerializer", MinecraftReflection.getDataWatcherSerializerClass(), (Class<?>[])new Class[0]));
            }
            if ((serializer = getSerializer.invoke(this.handle, new Object[0])) != null) {
                Serializer wrapper = Registry.fromHandle(serializer);
                if (wrapper != null) {
                    return wrapper;
                }
                return new Serializer(null, serializer, false);
            }
            return null;
        }

        public String toString() {
            return "DataWatcherObject[index=" + this.getIndex() + ", serializer=" + this.getSerializer() + "]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof WrappedDataWatcherObject) {
                WrappedDataWatcherObject other = (WrappedDataWatcherObject)obj;
                return this.handle.equals(other.handle);
            }
            return false;
        }
    }
}

