/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;

public class WrappedChatComponent
extends AbstractWrapper {
    private static final Class<?> SERIALIZER = MinecraftReflection.getChatSerializerClass();
    private static final Class<?> COMPONENT = MinecraftReflection.getIChatBaseComponentClass();
    private static MethodAccessor SERIALIZE_COMPONENT = null;
    private static MethodAccessor DESERIALIZE_COMPONENT = null;
    private static MethodAccessor CONSTRUCT_COMPONENT = null;
    private static ConstructorAccessor CONSTRUCT_TEXT_COMPONENT = null;
    private transient String cache;

    private static MethodAccessor findDeserialize(FuzzyReflection fuzzy) {
        List<Method> methods = fuzzy.getMethodListByParameters(COMPONENT, new Class[]{String.class});
        if (methods.isEmpty()) {
            throw new IllegalArgumentException("Unable to find deserialize method in " + fuzzy.getSource().getName());
        }
        for (Method method : methods) {
            if (!method.getName().equals("b")) continue;
            return Accessors.getMethodAccessor(method);
        }
        return Accessors.getMethodAccessor(methods.get(0));
    }

    private WrappedChatComponent(Object handle, String cache) {
        super(MinecraftReflection.getIChatBaseComponentClass());
        this.setHandle(handle);
        this.cache = cache;
    }

    public static WrappedChatComponent fromHandle(Object handle) {
        return new WrappedChatComponent(handle, null);
    }

    public static WrappedChatComponent fromJson(String json) {
        return new WrappedChatComponent(DESERIALIZE_COMPONENT.invoke(null, json), json);
    }

    public static WrappedChatComponent fromText(String text) {
        Preconditions.checkNotNull((Object)text, (Object)"text cannot be NULL.");
        return WrappedChatComponent.fromHandle(CONSTRUCT_TEXT_COMPONENT.invoke(text));
    }

    public static WrappedChatComponent[] fromChatMessage(String message) {
        Object[] components = (Object[])CONSTRUCT_COMPONENT.invoke(null, message);
        WrappedChatComponent[] result = new WrappedChatComponent[components.length];
        for (int i = 0; i < components.length; ++i) {
            result[i] = WrappedChatComponent.fromHandle(components[i]);
        }
        return result;
    }

    public String getJson() {
        if (this.cache == null) {
            this.cache = (String)SERIALIZE_COMPONENT.invoke(null, this.handle);
        }
        return this.cache;
    }

    public void setJson(String obj) {
        this.handle = DESERIALIZE_COMPONENT.invoke(null, obj);
        this.cache = obj;
    }

    public WrappedChatComponent deepClone() {
        return WrappedChatComponent.fromJson(this.getJson());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedChatComponent) {
            return ((WrappedChatComponent)obj).handle.equals(this.handle);
        }
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "WrappedChatComponent[json=" + this.getJson() + "]";
    }

    static {
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(SERIALIZER);
        SERIALIZE_COMPONENT = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("serialize", (Class<?>)String.class, (Class<?>[])new Class[]{COMPONENT}));
        DESERIALIZE_COMPONENT = WrappedChatComponent.findDeserialize(fuzzy);
        CONSTRUCT_COMPONENT = Accessors.getMethodAccessor(MinecraftReflection.getCraftChatMessage(), "fromString", String.class);
        CONSTRUCT_TEXT_COMPONENT = Accessors.getConstructorAccessor(MinecraftReflection.getChatComponentTextClass(), String.class);
    }
}

