/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BukkitConverters;
import org.bukkit.Material;

public class WrappedBlockData
extends AbstractWrapper {
    private static final Class<?> MAGIC_NUMBERS = MinecraftReflection.getCraftBukkitClass("util.CraftMagicNumbers");
    private static final Class<?> IBLOCK_DATA = MinecraftReflection.getIBlockDataClass();
    private static final Class<?> BLOCK = MinecraftReflection.getBlockClass();
    private static MethodAccessor FROM_LEGACY_DATA = null;
    private static MethodAccessor TO_LEGACY_DATA = null;
    private static MethodAccessor GET_NMS_BLOCK = null;
    private static MethodAccessor GET_BLOCK = null;

    public WrappedBlockData(Object handle) {
        super(IBLOCK_DATA);
        this.setHandle(handle);
    }

    public Material getType() {
        Object block = GET_BLOCK.invoke(this.handle, new Object[0]);
        return BukkitConverters.getBlockConverter().getSpecific(block);
    }

    @Deprecated
    public int getTypeId() {
        Object block = GET_BLOCK.invoke(this.handle, new Object[0]);
        return BukkitConverters.getBlockIDConverter().getSpecific(block);
    }

    public int getData() {
        Object block = GET_BLOCK.invoke(this.handle, new Object[0]);
        return (Integer)TO_LEGACY_DATA.invoke(block, this.handle);
    }

    public void setType(Material type) {
        this.setTypeAndData(type, 0);
    }

    public void setData(int data) {
        this.setTypeAndData(this.getType(), data);
    }

    public void setTypeAndData(Material type, int data) {
        Object nmsBlock = GET_NMS_BLOCK.invoke(null, type);
        Object blockData = FROM_LEGACY_DATA.invoke(nmsBlock, data);
        this.setHandle(blockData);
    }

    public static WrappedBlockData createData(Material type) {
        return WrappedBlockData.createData(type, 0);
    }

    public static WrappedBlockData createData(Material type, int data) {
        Object nmsBlock = GET_NMS_BLOCK.invoke(null, type);
        Object blockData = FROM_LEGACY_DATA.invoke(nmsBlock, data);
        return new WrappedBlockData(blockData);
    }

    public WrappedBlockData deepClone() {
        return WrappedBlockData.createData(this.getType(), this.getData());
    }

    public String toString() {
        return "WrappedBlockData[handle=" + this.handle + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof WrappedBlockData) {
            WrappedBlockData that = (WrappedBlockData)o;
            return this.getType() == that.getType();
        }
        return false;
    }

    static {
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(BLOCK);
        FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().banModifier(8).parameterExactArray(Integer.TYPE).returnTypeExact(IBLOCK_DATA).build();
        FROM_LEGACY_DATA = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
        contract = FuzzyMethodContract.newBuilder().banModifier(8).parameterExactArray(IBLOCK_DATA).returnTypeExact(Integer.TYPE).build();
        TO_LEGACY_DATA = Accessors.getMethodAccessor(fuzzy.getMethod(contract, "toLegacyData"));
        fuzzy = FuzzyReflection.fromClass(MAGIC_NUMBERS);
        GET_NMS_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("getBlock", BLOCK, (Class<?>[])new Class[]{Material.class}));
        fuzzy = FuzzyReflection.fromClass(IBLOCK_DATA);
        GET_BLOCK = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("getBlock", BLOCK, (Class<?>[])new Class[0]));
    }
}

