/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.ClassAnalyser;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyClassContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.CachedPackage;
import com.comphenix.protocol.utility.ClassSource;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.utility.RemappedClassSource;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class MinecraftReflection {
    public static final ReportType REPORT_CANNOT_FIND_MCPC_REMAPPER = new ReportType("Cannot find MCPC/Cauldron remapper.");
    public static final ReportType REPORT_CANNOT_LOAD_CPC_REMAPPER = new ReportType("Unable to load MCPC/Cauldron remapper.");
    public static final ReportType REPORT_NON_CRAFTBUKKIT_LIBRARY_PACKAGE = new ReportType("Cannot find standard Minecraft library location. Assuming MCPC/Cauldron.");
    private static final String CANONICAL_REGEX = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    @Deprecated
    public static final String MINECRAFT_OBJECT = "net\\.minecraft\\.(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static String DYNAMIC_PACKAGE_MATCHER = null;
    private static final String FORGE_ENTITY_PACKAGE = "net.minecraft.entity";
    private static String MINECRAFT_PREFIX_PACKAGE = "net.minecraft.server";
    private static final Pattern PACKAGE_VERSION_MATCHER = Pattern.compile(".*\\.(v\\d+_\\d+_\\w*\\d+)");
    private static String MINECRAFT_FULL_PACKAGE = null;
    private static String CRAFTBUKKIT_PACKAGE = null;
    static CachedPackage minecraftPackage;
    static CachedPackage craftbukkitPackage;
    static CachedPackage libraryPackage;
    private static AbstractFuzzyMatcher<Class<?>> fuzzyMatcher;
    private static String packageVersion;
    private static Method craftNMSMethod;
    private static Method craftBukkitNMS;
    private static Method craftBukkitOBC;
    private static boolean craftItemStackFailed;
    private static Constructor<?> craftNMSConstructor;
    private static Constructor<?> craftBukkitConstructor;
    private static Class<?> itemStackArrayClass;
    private static ConcurrentMap<Class<?>, MethodAccessor> getBukkitEntityCache;
    private static ClassSource classSource;
    private static boolean initializing;
    private static Boolean cachedNetty;

    private MinecraftReflection() {
    }

    public static String getMinecraftObjectRegex() {
        if (DYNAMIC_PACKAGE_MATCHER == null) {
            MinecraftReflection.getMinecraftPackage();
        }
        return DYNAMIC_PACKAGE_MATCHER;
    }

    public static AbstractFuzzyMatcher<Class<?>> getMinecraftObjectMatcher() {
        if (fuzzyMatcher == null) {
            fuzzyMatcher = FuzzyMatchers.matchRegex(MinecraftReflection.getMinecraftObjectRegex(), 50);
        }
        return fuzzyMatcher;
    }

    public static String getMinecraftPackage() {
        if (MINECRAFT_FULL_PACKAGE != null) {
            return MINECRAFT_FULL_PACKAGE;
        }
        if (initializing) {
            throw new IllegalStateException("Already initializing minecraft package!");
        }
        initializing = true;
        Server craftServer = Bukkit.getServer();
        if (craftServer != null) {
            try {
                Class<?> craftClass = craftServer.getClass();
                CRAFTBUKKIT_PACKAGE = MinecraftReflection.getPackage(craftClass.getCanonicalName());
                Matcher packageMatcher = PACKAGE_VERSION_MATCHER.matcher(CRAFTBUKKIT_PACKAGE);
                if (packageMatcher.matches()) {
                    packageVersion = packageMatcher.group(1);
                } else {
                    MinecraftVersion version = new MinecraftVersion(craftServer);
                    if (MinecraftVersion.SCARY_UPDATE.compareTo(version) <= 0) {
                        packageVersion = "v" + version.getMajor() + "_" + version.getMinor() + "_R1";
                        ProtocolLogger.log(Level.WARNING, "Assuming package version: " + packageVersion, new Object[0]);
                    }
                }
                MinecraftReflection.handleLibigot();
                Class<?> craftEntity = MinecraftReflection.getCraftEntityClass();
                Method getHandle = craftEntity.getMethod("getHandle", new Class[0]);
                MINECRAFT_FULL_PACKAGE = MinecraftReflection.getPackage(getHandle.getReturnType().getCanonicalName());
                if (!MINECRAFT_FULL_PACKAGE.startsWith(MINECRAFT_PREFIX_PACKAGE)) {
                    if (MINECRAFT_FULL_PACKAGE.equals(FORGE_ENTITY_PACKAGE)) {
                        MINECRAFT_FULL_PACKAGE = CachedPackage.combine(MINECRAFT_PREFIX_PACKAGE, packageVersion);
                    } else {
                        MINECRAFT_PREFIX_PACKAGE = MINECRAFT_FULL_PACKAGE;
                    }
                    String matcher = (MINECRAFT_PREFIX_PACKAGE.length() > 0 ? Pattern.quote(MINECRAFT_PREFIX_PACKAGE + ".") : "") + CANONICAL_REGEX;
                    MinecraftReflection.setDynamicPackageMatcher("(" + matcher + ")|(" + MINECRAFT_OBJECT + ")");
                } else {
                    MinecraftReflection.setDynamicPackageMatcher(MINECRAFT_OBJECT);
                }
                String string = MINECRAFT_FULL_PACKAGE;
                return string;
            }
            catch (SecurityException e) {
                throw new RuntimeException("Security violation. Cannot get handle method.", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot find getHandle() method on server. Is this a modified CraftBukkit version?", e);
            }
            finally {
                initializing = false;
            }
        }
        initializing = false;
        throw new IllegalStateException("Could not find Bukkit. Is it running?");
    }

    public static String getPackageVersion() {
        MinecraftReflection.getMinecraftPackage();
        return packageVersion;
    }

    private static void setDynamicPackageMatcher(String regex) {
        DYNAMIC_PACKAGE_MATCHER = regex;
        fuzzyMatcher = null;
    }

    private static void handleLibigot() {
        try {
            MinecraftReflection.getCraftEntityClass();
        }
        catch (RuntimeException e) {
            craftbukkitPackage = null;
            CRAFTBUKKIT_PACKAGE = "org.bukkit.craftbukkit";
            MinecraftReflection.getCraftEntityClass();
        }
    }

    public static void setMinecraftPackage(String minecraftPackage, String craftBukkitPackage) {
        MINECRAFT_FULL_PACKAGE = minecraftPackage;
        CRAFTBUKKIT_PACKAGE = craftBukkitPackage;
        if (MinecraftReflection.getMinecraftServerClass() == null) {
            throw new IllegalArgumentException("Cannot find MinecraftServer for package " + minecraftPackage);
        }
        MinecraftReflection.setDynamicPackageMatcher(MINECRAFT_OBJECT);
    }

    public static String getCraftBukkitPackage() {
        if (CRAFTBUKKIT_PACKAGE == null) {
            MinecraftReflection.getMinecraftPackage();
        }
        return CRAFTBUKKIT_PACKAGE;
    }

    private static String getPackage(String fullName) {
        int index = fullName.lastIndexOf(".");
        if (index > 0) {
            return fullName.substring(0, index);
        }
        return "";
    }

    public static Object getBukkitEntity(Object nmsObject) {
        if (nmsObject == null) {
            return null;
        }
        try {
            MethodAccessor created;
            Class<?> clazz = nmsObject.getClass();
            MethodAccessor accessor = (MethodAccessor)getBukkitEntityCache.get(clazz);
            if (accessor == null && (accessor = getBukkitEntityCache.putIfAbsent(clazz, created = Accessors.getMethodAccessor(clazz, "getBukkitEntity", new Class[0]))) == null) {
                accessor = created;
            }
            return accessor.invoke(nmsObject, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get Bukkit entity from " + nmsObject, e);
        }
    }

    public static boolean isMinecraftObject(@Nonnull Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().getName().startsWith(MINECRAFT_PREFIX_PACKAGE);
    }

    public static boolean isMinecraftClass(@Nonnull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be NULL.");
        }
        return MinecraftReflection.getMinecraftObjectMatcher().isMatch(clazz, null);
    }

    public static boolean isMinecraftObject(@Nonnull Object obj, String className) {
        if (obj == null) {
            return false;
        }
        String javaName = obj.getClass().getName();
        return javaName.startsWith(MINECRAFT_PREFIX_PACKAGE) && javaName.endsWith(className);
    }

    public static boolean isChunkPosition(Object obj) {
        Class<?> chunkPosition = MinecraftReflection.getChunkPositionClass();
        return obj != null && chunkPosition != null && chunkPosition.isAssignableFrom(obj.getClass());
    }

    public static boolean isBlockPosition(Object obj) {
        Class<?> blockPosition = MinecraftReflection.getBlockPositionClass();
        return obj != null && blockPosition != null && blockPosition.isAssignableFrom(obj.getClass());
    }

    public static boolean isChunkCoordIntPair(Object obj) {
        return obj != null && MinecraftReflection.getChunkCoordIntPair().isAssignableFrom(obj.getClass());
    }

    public static boolean isChunkCoordinates(Object obj) {
        Class<?> chunkCoordinates = MinecraftReflection.getChunkCoordinatesClass();
        return obj != null && chunkCoordinates != null && chunkCoordinates.isAssignableFrom(obj.getClass());
    }

    public static boolean isPacketClass(Object obj) {
        return obj != null && MinecraftReflection.getPacketClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isLoginHandler(Object obj) {
        return obj != null && MinecraftReflection.getNetLoginHandlerClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isServerHandler(Object obj) {
        return obj != null && MinecraftReflection.getPlayerConnectionClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isMinecraftEntity(Object obj) {
        return obj != null && MinecraftReflection.getEntityClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isItemStack(Object value) {
        return value != null && MinecraftReflection.getItemStackClass().isAssignableFrom(value.getClass());
    }

    public static boolean isCraftPlayer(Object value) {
        return value != null && MinecraftReflection.getCraftPlayerClass().isAssignableFrom(value.getClass());
    }

    public static boolean isMinecraftPlayer(Object obj) {
        return obj != null && MinecraftReflection.getEntityPlayerClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isWatchableObject(Object obj) {
        return obj != null && MinecraftReflection.getWatchableObjectClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isDataWatcher(Object obj) {
        return obj != null && MinecraftReflection.getDataWatcherClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isIntHashMap(Object obj) {
        return obj != null && MinecraftReflection.getIntHashMapClass().isAssignableFrom(obj.getClass());
    }

    public static boolean isCraftItemStack(Object obj) {
        return obj != null && MinecraftReflection.getCraftItemStackClass().isAssignableFrom(obj.getClass());
    }

    public static Class<?> getEntityPlayerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("EntityPlayer");
        }
        catch (RuntimeException e) {
            try {
                Method getHandle = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass("entity.CraftPlayer")).getMethodByName("getHandle");
                return MinecraftReflection.setMinecraftClass("EntityPlayer", getHandle.getReturnType());
            }
            catch (IllegalArgumentException e1) {
                throw new RuntimeException("Could not find EntityPlayer class.", e1);
            }
        }
    }

    public static Class<?> getEntityHumanClass() {
        return MinecraftReflection.getEntityPlayerClass().getSuperclass();
    }

    public static Class<?> getGameProfileClass() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalStateException("GameProfile does not exist in version 1.6.4 and earlier.");
        }
        try {
            return MinecraftReflection.getClass("com.mojang.authlib.GameProfile");
        }
        catch (Throwable ex) {
            try {
                return MinecraftReflection.getClass("net.minecraft.util.com.mojang.authlib.GameProfile");
            }
            catch (Throwable ex1) {
                FuzzyReflection reflection = FuzzyReflection.fromClass(PacketType.Login.Client.START.getPacketClass(), true);
                FuzzyFieldContract contract = FuzzyFieldContract.newBuilder().banModifier(8).typeMatches(FuzzyMatchers.matchRegex("(.*)(GameProfile)", 1)).build();
                return reflection.getField(contract).getType();
            }
        }
    }

    public static Class<?> getEntityClass() {
        try {
            return MinecraftReflection.getMinecraftClass("Entity");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.fallbackMethodReturn("Entity", "entity.CraftEntity", "getHandle");
        }
    }

    public static Class<?> getCraftChatMessage() {
        return MinecraftReflection.getCraftBukkitClass("util.CraftChatMessage");
    }

    public static Class<?> getWorldServerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("WorldServer");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.fallbackMethodReturn("WorldServer", "CraftWorld", "getHandle");
        }
    }

    public static Class<?> getNmsWorldClass() {
        try {
            return MinecraftReflection.getMinecraftClass("World");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.setMinecraftClass("World", MinecraftReflection.getWorldServerClass().getSuperclass());
        }
    }

    private static Class<?> fallbackMethodReturn(String nmsClass, String craftClass, String methodName) {
        Class<?> result = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass(craftClass)).getMethodByName(methodName).getReturnType();
        return MinecraftReflection.setMinecraftClass(nmsClass, result);
    }

    public static Class<?> getPacketClass() {
        try {
            return MinecraftReflection.getMinecraftClass("Packet");
        }
        catch (RuntimeException e) {
            FuzzyClassContract paketContract = null;
            paketContract = MinecraftReflection.isUsingNetty() ? FuzzyClassContract.newBuilder().method(FuzzyMethodContract.newBuilder().parameterDerivedOf(MinecraftReflection.getByteBufClass()).returnTypeVoid()).method(FuzzyMethodContract.newBuilder().parameterDerivedOf(MinecraftReflection.getByteBufClass(), 0).parameterExactType(byte[].class, 1).returnTypeVoid()).build() : FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().typeDerivedOf(Map.class).requireModifier(8)).field(FuzzyFieldContract.newBuilder().typeDerivedOf(Set.class).requireModifier(8)).method(FuzzyMethodContract.newBuilder().parameterSuperOf(DataInputStream.class).returnTypeVoid()).build();
            Method selected = FuzzyReflection.fromClass(MinecraftReflection.getPlayerConnectionClass()).getMethod(FuzzyMethodContract.newBuilder().parameterMatches(paketContract, 0).parameterCount(1).build());
            Class<?> clazz = MinecraftReflection.getTopmostClass(selected.getParameterTypes()[0]);
            return MinecraftReflection.setMinecraftClass("Packet", clazz);
        }
    }

    public static Class<?> getByteBufClass() {
        try {
            return MinecraftReflection.getClass("io.netty.buffer.ByteBuf");
        }
        catch (Throwable ex) {
            return MinecraftReflection.getClass("net.minecraft.util.io.netty.buffer.ByteBuf");
        }
    }

    public static Class<?> getEnumProtocolClass() {
        try {
            return MinecraftReflection.getMinecraftClass("EnumProtocol");
        }
        catch (RuntimeException e) {
            Method protocolMethod = FuzzyReflection.fromClass(MinecraftReflection.getNetworkManagerClass()).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(Enum.class, 0).build());
            return MinecraftReflection.setMinecraftClass("EnumProtocol", protocolMethod.getParameterTypes()[0]);
        }
    }

    public static Class<?> getIChatBaseComponentClass() {
        try {
            return MinecraftReflection.getMinecraftClass("IChatBaseComponent");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.setMinecraftClass("IChatBaseComponent", Accessors.getMethodAccessor(MinecraftReflection.getCraftChatMessage(), "fromString", String.class).getMethod().getReturnType().getComponentType());
        }
    }

    public static Class<?> getIChatBaseComponentArrayClass() {
        return MinecraftReflection.getArrayClass(MinecraftReflection.getIChatBaseComponentClass());
    }

    public static Class<?> getChatComponentTextClass() {
        try {
            return MinecraftReflection.getMinecraftClass("ChatComponentText");
        }
        catch (RuntimeException e) {
            try {
                Method getScoreboardDisplayName = FuzzyReflection.fromClass(MinecraftReflection.getEntityClass()).getMethodByParameters("getScoreboardDisplayName", MinecraftReflection.getIChatBaseComponentClass(), (Class<?>[])new Class[0]);
                Class<?> baseClass = MinecraftReflection.getIChatBaseComponentClass();
                for (ClassAnalyser.AsmMethod method : ClassAnalyser.getDefault().getMethodCalls(getScoreboardDisplayName)) {
                    Class<?> owner = method.getOwnerClass();
                    if (!MinecraftReflection.isMinecraftClass(owner) || !baseClass.isAssignableFrom(owner)) continue;
                    return MinecraftReflection.setMinecraftClass("ChatComponentText", owner);
                }
            }
            catch (Exception e1) {
                throw new IllegalStateException("Cannot find ChatComponentText class.", e);
            }
            throw new IllegalStateException("Cannot find ChatComponentText class.");
        }
    }

    public static Class<?> getChatSerializerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("ChatSerializer", "IChatBaseComponent$ChatSerializer");
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Could not find ChatSerializer class.", e);
        }
    }

    public static Class<?> getServerPingClass() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalStateException("ServerPing is only supported in 1.7.2.");
        }
        try {
            return MinecraftReflection.getMinecraftClass("ServerPing");
        }
        catch (RuntimeException e) {
            Class<?> statusServerInfo = PacketType.Status.Server.SERVER_INFO.getPacketClass();
            AbstractFuzzyMatcher<Class<?>> serverPingContract = FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().typeExact(String.class).build()).field(FuzzyFieldContract.newBuilder().typeDerivedOf(MinecraftReflection.getIChatBaseComponentClass()).build()).build().and(MinecraftReflection.getMinecraftObjectMatcher());
            return MinecraftReflection.setMinecraftClass("ServerPing", FuzzyReflection.fromClass(statusServerInfo, true).getField(FuzzyFieldContract.matchType(serverPingContract)).getType());
        }
    }

    public static Class<?> getServerPingServerDataClass() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalStateException("ServerPingServerData is only supported in 1.7.2.");
        }
        try {
            return MinecraftReflection.getMinecraftClass("ServerPingServerData", "ServerPing$ServerData");
        }
        catch (RuntimeException e) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(MinecraftReflection.getServerPingClass(), true);
            return MinecraftReflection.setMinecraftClass("ServerPingServerData", fuzzy.getFieldByType("(.*)(ServerData)(.*)").getType());
        }
    }

    public static Class<?> getServerPingPlayerSampleClass() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalStateException("ServerPingPlayerSample is only supported in 1.7.2.");
        }
        try {
            return MinecraftReflection.getMinecraftClass("ServerPingPlayerSample", "ServerPing$ServerPingPlayerSample");
        }
        catch (RuntimeException e) {
            Class<?> serverPing = MinecraftReflection.getServerPingClass();
            AbstractFuzzyMatcher<Class<?>> serverPlayerContract = FuzzyClassContract.newBuilder().constructor(FuzzyMethodContract.newBuilder().parameterExactArray(Integer.TYPE, Integer.TYPE)).field(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getArrayClass(MinecraftReflection.getGameProfileClass()))).build().and(MinecraftReflection.getMinecraftObjectMatcher());
            return MinecraftReflection.setMinecraftClass("ServerPingPlayerSample", MinecraftReflection.getTypeFromField(serverPing, serverPlayerContract));
        }
    }

    private static Class<?> getTypeFromField(Class<?> clazz, AbstractFuzzyMatcher<Class<?>> fieldTypeMatcher) {
        FuzzyFieldContract fieldMatcher = FuzzyFieldContract.matchType(fieldTypeMatcher);
        return FuzzyReflection.fromClass(clazz, true).getField(fieldMatcher).getType();
    }

    public static boolean isUsingNetty() {
        if (cachedNetty == null) {
            try {
                cachedNetty = MinecraftReflection.getEnumProtocolClass() != null;
            }
            catch (RuntimeException e) {
                cachedNetty = false;
            }
        }
        return cachedNetty;
    }

    private static Class<?> getTopmostClass(Class<?> clazz) {
        Class<?> superClass;
        while ((superClass = clazz.getSuperclass()) != Object.class && superClass != null) {
            clazz = superClass;
        }
        return clazz;
    }

    public static Class<?> getMinecraftServerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("MinecraftServer");
        }
        catch (RuntimeException e) {
            MinecraftReflection.useFallbackServer();
            return MinecraftReflection.getMinecraftClass("MinecraftServer");
        }
    }

    public static Class<?> getStatisticClass() {
        return MinecraftReflection.getMinecraftClass("Statistic");
    }

    public static Class<?> getStatisticListClass() {
        return MinecraftReflection.getMinecraftClass("StatisticList");
    }

    private static void useFallbackServer() {
        Constructor<?> selected = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass("CraftServer")).getConstructor(FuzzyMethodContract.newBuilder().parameterMatches(MinecraftReflection.getMinecraftObjectMatcher(), 0).parameterCount(2).build());
        Class<?>[] params = selected.getParameterTypes();
        MinecraftReflection.setMinecraftClass("MinecraftServer", params[0]);
        MinecraftReflection.setMinecraftClass("ServerConfigurationManager", params[1]);
    }

    public static Class<?> getPlayerListClass() {
        try {
            return MinecraftReflection.getMinecraftClass("ServerConfigurationManager", "PlayerList");
        }
        catch (RuntimeException e) {
            MinecraftReflection.useFallbackServer();
            return MinecraftReflection.getMinecraftClass("ServerConfigurationManager");
        }
    }

    public static Class<?> getNetLoginHandlerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("NetLoginHandler", "PendingConnection");
        }
        catch (RuntimeException e) {
            Method selected = FuzzyReflection.fromClass(MinecraftReflection.getPlayerListClass()).getMethod(FuzzyMethodContract.newBuilder().parameterMatches(FuzzyMatchers.matchExact(MinecraftReflection.getEntityPlayerClass()).inverted(), 0).parameterExactType(String.class, 1).parameterExactType(String.class, 2).build());
            return MinecraftReflection.setMinecraftClass("NetLoginHandler", selected.getParameterTypes()[0]);
        }
    }

    public static Class<?> getPlayerConnectionClass() {
        try {
            return MinecraftReflection.getMinecraftClass("PlayerConnection", "NetServerHandler");
        }
        catch (RuntimeException e) {
            try {
                return MinecraftReflection.setMinecraftClass("PlayerConnection", FuzzyReflection.fromClass(MinecraftReflection.getEntityPlayerClass()).getFieldByType("playerConnection", MinecraftReflection.getNetHandlerClass()).getType());
            }
            catch (RuntimeException e1) {
                Class<?> playerClass = MinecraftReflection.getEntityPlayerClass();
                FuzzyClassContract playerConnection = FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().typeExact(playerClass).build()).constructor(FuzzyMethodContract.newBuilder().parameterCount(3).parameterSuperOf(MinecraftReflection.getMinecraftServerClass(), 0).parameterSuperOf(MinecraftReflection.getEntityPlayerClass(), 2).build()).method(FuzzyMethodContract.newBuilder().parameterCount(1).parameterExactType(String.class).build()).build();
                Class<?> fieldType = FuzzyReflection.fromClass(MinecraftReflection.getEntityPlayerClass(), true).getField(FuzzyFieldContract.newBuilder().typeMatches(playerConnection).build()).getType();
                return MinecraftReflection.setMinecraftClass("PlayerConnection", fieldType);
            }
        }
    }

    public static Class<?> getNetworkManagerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("INetworkManager", "NetworkManager");
        }
        catch (RuntimeException e) {
            Constructor<?> selected = FuzzyReflection.fromClass(MinecraftReflection.getPlayerConnectionClass()).getConstructor(FuzzyMethodContract.newBuilder().parameterSuperOf(MinecraftReflection.getMinecraftServerClass(), 0).parameterSuperOf(MinecraftReflection.getEntityPlayerClass(), 2).build());
            return MinecraftReflection.setMinecraftClass("INetworkManager", selected.getParameterTypes()[1]);
        }
    }

    public static Class<?> getNetHandlerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("NetHandler", "Connection");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.setMinecraftClass("NetHandler", MinecraftReflection.getNetLoginHandlerClass().getSuperclass());
        }
    }

    public static Class<?> getItemStackClass() {
        try {
            return MinecraftReflection.getMinecraftClass("ItemStack");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.setMinecraftClass("ItemStack", FuzzyReflection.fromClass(MinecraftReflection.getCraftItemStackClass(), true).getFieldByName("handle").getType());
        }
    }

    public static Class<?> getBlockClass() {
        try {
            return MinecraftReflection.getMinecraftClass("Block");
        }
        catch (RuntimeException e) {
            FuzzyReflection reflect = FuzzyReflection.fromClass(MinecraftReflection.getItemStackClass());
            HashSet candidates = new HashSet();
            for (Constructor<?> constructor : reflect.getConstructors()) {
                for (Class<?> clazz : constructor.getParameterTypes()) {
                    if (!MinecraftReflection.isMinecraftClass(clazz)) continue;
                    candidates.add(clazz);
                }
            }
            Method selected = reflect.getMethod(FuzzyMethodContract.newBuilder().parameterMatches(FuzzyMatchers.matchAnyOf(candidates)).returnTypeExact(Float.TYPE).build());
            return MinecraftReflection.setMinecraftClass("Block", selected.getParameterTypes()[0]);
        }
    }

    public static Class<?> getWorldTypeClass() {
        try {
            return MinecraftReflection.getMinecraftClass("WorldType");
        }
        catch (RuntimeException e) {
            Method selected = FuzzyReflection.fromClass(MinecraftReflection.getMinecraftServerClass(), true).getMethod(FuzzyMethodContract.newBuilder().parameterExactType(String.class, 0).parameterExactType(String.class, 1).parameterMatches(MinecraftReflection.getMinecraftObjectMatcher()).parameterExactType(String.class, 4).parameterCount(5).build());
            return MinecraftReflection.setMinecraftClass("WorldType", selected.getParameterTypes()[3]);
        }
    }

    public static Class<?> getDataWatcherClass() {
        try {
            return MinecraftReflection.getMinecraftClass("DataWatcher");
        }
        catch (RuntimeException e) {
            FuzzyClassContract dataWatcherContract = FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().requireModifier(8).typeDerivedOf(Map.class)).field(FuzzyFieldContract.newBuilder().banModifier(8).typeDerivedOf(Map.class)).method(FuzzyMethodContract.newBuilder().parameterExactType(Integer.TYPE).parameterExactType(Object.class).returnTypeVoid()).build();
            FuzzyFieldContract fieldContract = FuzzyFieldContract.newBuilder().typeMatches(dataWatcherContract).build();
            return MinecraftReflection.setMinecraftClass("DataWatcher", FuzzyReflection.fromClass(MinecraftReflection.getEntityClass(), true).getField(fieldContract).getType());
        }
    }

    public static Class<?> getChunkPositionClass() {
        try {
            return MinecraftReflection.getMinecraftClass("ChunkPosition");
        }
        catch (RuntimeException e) {
            try {
                Class<?> normalChunkGenerator = MinecraftReflection.getCraftBukkitClass("generator.NormalChunkGenerator");
                FuzzyMethodContract selected = FuzzyMethodContract.newBuilder().banModifier(8).parameterMatches(MinecraftReflection.getMinecraftObjectMatcher(), 0).parameterExactType(String.class, 1).parameterExactType(Integer.TYPE, 2).parameterExactType(Integer.TYPE, 3).parameterExactType(Integer.TYPE, 4).build();
                return MinecraftReflection.setMinecraftClass("ChunkPosition", FuzzyReflection.fromClass(normalChunkGenerator).getMethod(selected).getReturnType());
            }
            catch (Throwable ex) {
                return null;
            }
        }
    }

    public static Class<?> getBlockPositionClass() {
        try {
            return MinecraftReflection.getMinecraftClass("BlockPosition");
        }
        catch (RuntimeException e) {
            try {
                Class<?> normalChunkGenerator = MinecraftReflection.getCraftBukkitClass("generator.NormalChunkGenerator");
                FuzzyMethodContract selected = FuzzyMethodContract.newBuilder().banModifier(8).parameterMatches(MinecraftReflection.getMinecraftObjectMatcher(), 0).parameterExactType(String.class, 1).parameterMatches(MinecraftReflection.getMinecraftObjectMatcher(), 1).build();
                return MinecraftReflection.setMinecraftClass("BlockPosition", FuzzyReflection.fromClass(normalChunkGenerator).getMethod(selected).getReturnType());
            }
            catch (Throwable ex) {
                return null;
            }
        }
    }

    public static Class<?> getVec3DClass() {
        try {
            return MinecraftReflection.getMinecraftClass("Vec3D");
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Class<?> getChunkCoordinatesClass() {
        try {
            return MinecraftReflection.getMinecraftClass("ChunkCoordinates");
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Class<?> getChunkCoordIntPair() {
        if (!MinecraftReflection.isUsingNetty()) {
            throw new IllegalArgumentException("Not supported on 1.6.4 and older.");
        }
        try {
            return MinecraftReflection.getMinecraftClass("ChunkCoordIntPair");
        }
        catch (RuntimeException e) {
            Class packet = PacketRegistry.getPacketClassFromType(PacketType.Play.Server.MULTI_BLOCK_CHANGE);
            AbstractFuzzyMatcher<Class<?>> chunkCoordIntContract = FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().typeDerivedOf(Integer.TYPE)).field(FuzzyFieldContract.newBuilder().typeDerivedOf(Integer.TYPE)).method(FuzzyMethodContract.newBuilder().parameterExactArray(Integer.TYPE).returnDerivedOf(MinecraftReflection.getChunkPositionClass())).build().and(MinecraftReflection.getMinecraftObjectMatcher());
            Field field = FuzzyReflection.fromClass(packet, true).getField(FuzzyFieldContract.matchType(chunkCoordIntContract));
            return MinecraftReflection.setMinecraftClass("ChunkCoordIntPair", field.getType());
        }
    }

    @Deprecated
    public static Class<?> getWatchableObjectClass() {
        return MinecraftReflection.getDataWatcherItemClass();
    }

    public static Class<?> getDataWatcherItemClass() {
        try {
            return MinecraftReflection.getMinecraftClass("DataWatcher$Item", "DataWatcher$WatchableObject", "WatchableObject");
        }
        catch (RuntimeException e) {
            Method selected = FuzzyReflection.fromClass(MinecraftReflection.getDataWatcherClass(), true).getMethod(FuzzyMethodContract.newBuilder().requireModifier(8).parameterDerivedOf(MinecraftReflection.isUsingNetty() ? MinecraftReflection.getPacketDataSerializerClass() : DataOutput.class, 0).parameterMatches(MinecraftReflection.getMinecraftObjectMatcher(), 1).build());
            return MinecraftReflection.setMinecraftClass("DataWatcher$Item", selected.getParameterTypes()[1]);
        }
    }

    public static Class<?> getDataWatcherObjectClass() {
        return MinecraftReflection.getMinecraftClass("DataWatcherObject");
    }

    public static boolean watcherObjectExists() {
        try {
            return MinecraftReflection.getDataWatcherObjectClass() != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static Class<?> getDataWatcherSerializerClass() {
        return MinecraftReflection.getMinecraftClass("DataWatcherSerializer");
    }

    public static Class<?> getDataWatcherRegistryClass() {
        return MinecraftReflection.getMinecraftClass("DataWatcherRegistry");
    }

    public static Class<?> getMinecraftKeyClass() {
        return MinecraftReflection.getMinecraftClass("MinecraftKey");
    }

    public static Class<?> getMobEffectListClass() {
        return MinecraftReflection.getMinecraftClass("MobEffectList");
    }

    public static Class<?> getSoundEffectClass() {
        try {
            return MinecraftReflection.getMinecraftClass("SoundEffect");
        }
        catch (RuntimeException ex) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(PacketType.Play.Server.NAMED_SOUND_EFFECT.getPacketClass(), true);
            Field field = fuzzy.getFieldByType("(.*)(Sound)(.*)");
            return MinecraftReflection.setMinecraftClass("SoundEffect", field.getType());
        }
    }

    public static Class<?> getServerConnectionClass() {
        try {
            return MinecraftReflection.getMinecraftClass("ServerConnection");
        }
        catch (RuntimeException e) {
            Method selected = null;
            FuzzyClassContract.Builder serverConnectionContract = FuzzyClassContract.newBuilder().constructor(FuzzyMethodContract.newBuilder().parameterExactType(MinecraftReflection.getMinecraftServerClass()).parameterCount(1));
            if (MinecraftReflection.isUsingNetty()) {
                serverConnectionContract.method(FuzzyMethodContract.newBuilder().parameterDerivedOf(InetAddress.class, 0).parameterDerivedOf(Integer.TYPE, 1).parameterCount(2));
                selected = FuzzyReflection.fromClass(MinecraftReflection.getMinecraftServerClass()).getMethod(FuzzyMethodContract.newBuilder().requireModifier(1).returnTypeMatches(serverConnectionContract.build()).build());
            } else {
                serverConnectionContract.method(FuzzyMethodContract.newBuilder().parameterExactType(MinecraftReflection.getPlayerConnectionClass()));
                selected = FuzzyReflection.fromClass(MinecraftReflection.getMinecraftServerClass()).getMethod(FuzzyMethodContract.newBuilder().requireModifier(1024).returnTypeMatches(serverConnectionContract.build()).build());
            }
            return MinecraftReflection.setMinecraftClass("ServerConnection", selected.getReturnType());
        }
    }

    public static Class<?> getNBTBaseClass() {
        try {
            return MinecraftReflection.getMinecraftClass("NBTBase");
        }
        catch (RuntimeException e) {
            Class<?> nbtBase = null;
            if (MinecraftReflection.isUsingNetty()) {
                FuzzyClassContract tagCompoundContract = FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().typeDerivedOf(Map.class)).method(FuzzyMethodContract.newBuilder().parameterDerivedOf(DataOutput.class).parameterCount(1)).build();
                Method selected = FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass()).getMethod(FuzzyMethodContract.newBuilder().banModifier(8).parameterCount(1).parameterMatches(tagCompoundContract).returnTypeVoid().build());
                nbtBase = selected.getParameterTypes()[0].getSuperclass();
            } else {
                FuzzyClassContract tagCompoundContract = FuzzyClassContract.newBuilder().constructor(FuzzyMethodContract.newBuilder().parameterExactType(String.class).parameterCount(1)).field(FuzzyFieldContract.newBuilder().typeDerivedOf(Map.class)).build();
                Method selected = FuzzyReflection.fromClass(MinecraftReflection.getPacketClass()).getMethod(FuzzyMethodContract.newBuilder().requireModifier(8).parameterSuperOf(DataInputStream.class).parameterCount(1).returnTypeMatches(tagCompoundContract).build());
                nbtBase = selected.getReturnType().getSuperclass();
            }
            if (nbtBase == null || nbtBase.equals(Object.class)) {
                throw new IllegalStateException("Unable to find NBT base class: " + nbtBase);
            }
            return MinecraftReflection.setMinecraftClass("NBTBase", nbtBase);
        }
    }

    public static Class<?> getNBTReadLimiterClass() {
        return MinecraftReflection.getMinecraftClass("NBTReadLimiter");
    }

    public static Class<?> getNBTCompoundClass() {
        try {
            return MinecraftReflection.getMinecraftClass("NBTTagCompound");
        }
        catch (RuntimeException e) {
            return MinecraftReflection.setMinecraftClass("NBTTagCompound", NbtFactory.ofWrapper(NbtType.TAG_COMPOUND, "Test").getHandle().getClass());
        }
    }

    public static Class<?> getEntityTrackerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("EntityTracker");
        }
        catch (RuntimeException e) {
            FuzzyClassContract entityTrackerContract = FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().typeDerivedOf(Set.class)).method(FuzzyMethodContract.newBuilder().parameterSuperOf(MinecraftReflection.getEntityClass()).parameterCount(1).returnTypeVoid()).method(FuzzyMethodContract.newBuilder().parameterSuperOf(MinecraftReflection.getEntityClass(), 0).parameterSuperOf(Integer.TYPE, 1).parameterSuperOf(Integer.TYPE, 2).parameterCount(3).returnTypeVoid()).build();
            Field selected = FuzzyReflection.fromClass(MinecraftReflection.getWorldServerClass(), true).getField(FuzzyFieldContract.newBuilder().typeMatches(entityTrackerContract).build());
            return MinecraftReflection.setMinecraftClass("EntityTracker", selected.getType());
        }
    }

    public static Class<?> getNetworkListenThreadClass() {
        try {
            return MinecraftReflection.getMinecraftClass("NetworkListenThread");
        }
        catch (RuntimeException e) {
            FuzzyClassContract networkListenContract = FuzzyClassContract.newBuilder().field(FuzzyFieldContract.newBuilder().typeDerivedOf(ServerSocket.class)).field(FuzzyFieldContract.newBuilder().typeDerivedOf(Thread.class)).field(FuzzyFieldContract.newBuilder().typeDerivedOf(List.class)).method(FuzzyMethodContract.newBuilder().parameterExactType(MinecraftReflection.getPlayerConnectionClass())).build();
            Field selected = FuzzyReflection.fromClass(MinecraftReflection.getMinecraftServerClass(), true).getField(FuzzyFieldContract.newBuilder().typeMatches(networkListenContract).build());
            return MinecraftReflection.setMinecraftClass("NetworkListenThread", selected.getType());
        }
    }

    public static Class<?> getAttributeSnapshotClass() {
        try {
            return MinecraftReflection.getMinecraftClass("AttributeSnapshot", "PacketPlayOutUpdateAttributes$AttributeSnapshot");
        }
        catch (RuntimeException ex) {
            try {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(PacketType.Play.Server.UPDATE_ATTRIBUTES.getPacketClass(), true);
                Field field = fuzzy.getFieldByType("attributes", Collection.class);
                Type param = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                return MinecraftReflection.setMinecraftClass("AttributeSnapshot", (Class)param);
            }
            catch (Throwable ex1) {
                return MinecraftReflection.getMinecraftClass("AttributeSnapshot");
            }
        }
    }

    public static Class<?> getIntHashMapClass() {
        try {
            return MinecraftReflection.getMinecraftClass("IntHashMap");
        }
        catch (RuntimeException e) {
            Class<?> parent = MinecraftReflection.getEntityTrackerClass();
            FuzzyClassContract intHashContract = FuzzyClassContract.newBuilder().method(FuzzyMethodContract.newBuilder().parameterCount(2).parameterExactType(Integer.TYPE, 0).parameterExactType(Object.class, 1).requirePublic()).method(FuzzyMethodContract.newBuilder().parameterCount(1).parameterExactType(Integer.TYPE).returnTypeExact(Object.class).requirePublic()).field(FuzzyFieldContract.newBuilder().typeMatches(FuzzyMatchers.matchArray(FuzzyMatchers.matchAll()))).build();
            FuzzyFieldContract intHashField = FuzzyFieldContract.newBuilder().typeMatches(MinecraftReflection.getMinecraftObjectMatcher().and(intHashContract)).build();
            return MinecraftReflection.setMinecraftClass("IntHashMap", FuzzyReflection.fromClass(parent).getField(intHashField).getType());
        }
    }

    public static Class<?> getAttributeModifierClass() {
        try {
            return MinecraftReflection.getMinecraftClass("AttributeModifier");
        }
        catch (RuntimeException e) {
            MinecraftReflection.getAttributeSnapshotClass();
            return MinecraftReflection.getMinecraftClass("AttributeModifier");
        }
    }

    public static Class<?> getMobEffectClass() {
        try {
            return MinecraftReflection.getMinecraftClass("MobEffect");
        }
        catch (RuntimeException e) {
            Class packet = PacketRegistry.getPacketClassFromType(PacketType.Play.Server.ENTITY_EFFECT);
            Constructor<?> constructor = FuzzyReflection.fromClass(packet).getConstructor(FuzzyMethodContract.newBuilder().parameterCount(2).parameterExactType(Integer.TYPE, 0).parameterMatches(MinecraftReflection.getMinecraftObjectMatcher(), 1).build());
            return MinecraftReflection.setMinecraftClass("MobEffect", constructor.getParameterTypes()[1]);
        }
    }

    public static Class<?> getPacketDataSerializerClass() {
        try {
            return MinecraftReflection.getMinecraftClass("PacketDataSerializer");
        }
        catch (RuntimeException e) {
            Class<?> packet = MinecraftReflection.getPacketClass();
            Method method = FuzzyReflection.fromClass(packet).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(MinecraftReflection.getByteBufClass()).returnTypeVoid().build());
            return MinecraftReflection.setMinecraftClass("PacketDataSerializer", method.getParameterTypes()[0]);
        }
    }

    public static Class<?> getNbtCompressedStreamToolsClass() {
        try {
            return MinecraftReflection.getMinecraftClass("NBTCompressedStreamTools");
        }
        catch (RuntimeException e) {
            Class<?> packetSerializer = MinecraftReflection.getPacketDataSerializerClass();
            Method writeNbt = FuzzyReflection.fromClass(packetSerializer).getMethodByParameters("writeNbt", MinecraftReflection.getNBTCompoundClass());
            try {
                for (ClassAnalyser.AsmMethod method : ClassAnalyser.getDefault().getMethodCalls(writeNbt)) {
                    Class<?> owner = method.getOwnerClass();
                    if (packetSerializer.equals(owner) || !MinecraftReflection.isMinecraftClass(owner)) continue;
                    return MinecraftReflection.setMinecraftClass("NBTCompressedStreamTools", owner);
                }
            }
            catch (Exception e1) {
                throw new RuntimeException("Unable to analyse class.", e1);
            }
            throw new IllegalArgumentException("Unable to find NBTCompressedStreamTools.");
        }
    }

    public static Class<?> getTileEntityClass() {
        return MinecraftReflection.getMinecraftClass("TileEntity");
    }

    public static Class<?> getMinecraftGsonClass() {
        try {
            return MinecraftReflection.getMinecraftLibraryClass("com.google.gson.Gson");
        }
        catch (RuntimeException e) {
            Class<?> match = FuzzyReflection.fromClass(PacketType.Status.Server.SERVER_INFO.getPacketClass(), true).getFieldByType("(.*)(google.gson.Gson)").getType();
            return MinecraftReflection.setMinecraftLibraryClass("com.google.gson.Gson", match);
        }
    }

    public static Class<?> getItemStackArrayClass() {
        if (itemStackArrayClass == null) {
            itemStackArrayClass = MinecraftReflection.getArrayClass(MinecraftReflection.getItemStackClass());
        }
        return itemStackArrayClass;
    }

    public static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Class<?> getCraftItemStackClass() {
        return MinecraftReflection.getCraftBukkitClass("inventory.CraftItemStack");
    }

    public static Class<?> getCraftPlayerClass() {
        return MinecraftReflection.getCraftBukkitClass("entity.CraftPlayer");
    }

    public static Class<?> getCraftWorldClass() {
        return MinecraftReflection.getCraftBukkitClass("CraftWorld");
    }

    public static Class<?> getCraftEntityClass() {
        return MinecraftReflection.getCraftBukkitClass("entity.CraftEntity");
    }

    public static Class<?> getCraftMessageClass() {
        return MinecraftReflection.getCraftBukkitClass("util.CraftChatMessage");
    }

    public static Class<?> getPlayerInfoDataClass() {
        return MinecraftReflection.getMinecraftClass("PacketPlayOutPlayerInfo$PlayerInfoData", "PlayerInfoData");
    }

    public static boolean isPlayerInfoData(Object obj) {
        Class<?> clazz = MinecraftReflection.getPlayerInfoDataClass();
        return clazz != null && obj.getClass().equals(clazz);
    }

    public static Class<?> getIBlockDataClass() {
        return MinecraftReflection.getMinecraftClass("IBlockData");
    }

    public static Class<?> getMultiBlockChangeInfoClass() {
        return MinecraftReflection.getMinecraftClass("MultiBlockChangeInfo", "PacketPlayOutMultiBlockChange$MultiBlockChangeInfo");
    }

    public static Class<?> getMultiBlockChangeInfoArrayClass() {
        return MinecraftReflection.getArrayClass(MinecraftReflection.getMultiBlockChangeInfoClass());
    }

    public static ItemStack getBukkitItemStack(ItemStack bukkitItemStack) {
        if (craftBukkitNMS != null) {
            return MinecraftReflection.getBukkitItemByMethod(bukkitItemStack);
        }
        if (craftBukkitConstructor == null) {
            try {
                craftBukkitConstructor = MinecraftReflection.getCraftItemStackClass().getConstructor(ItemStack.class);
            }
            catch (Exception e) {
                if (!craftItemStackFailed) {
                    return MinecraftReflection.getBukkitItemByMethod(bukkitItemStack);
                }
                throw new RuntimeException("Cannot find CraftItemStack(org.bukkit.inventory.ItemStack).", e);
            }
        }
        try {
            return (ItemStack)craftBukkitConstructor.newInstance(bukkitItemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct CraftItemStack.", e);
        }
    }

    private static ItemStack getBukkitItemByMethod(ItemStack bukkitItemStack) {
        if (craftBukkitNMS == null) {
            try {
                craftBukkitNMS = MinecraftReflection.getCraftItemStackClass().getMethod("asNMSCopy", ItemStack.class);
                craftBukkitOBC = MinecraftReflection.getCraftItemStackClass().getMethod("asCraftMirror", MinecraftReflection.getItemStackClass());
            }
            catch (Exception e) {
                craftItemStackFailed = true;
                throw new RuntimeException("Cannot find CraftItemStack.asCraftCopy(org.bukkit.inventory.ItemStack).", e);
            }
        }
        try {
            Object nmsItemStack = craftBukkitNMS.invoke(null, bukkitItemStack);
            return (ItemStack)craftBukkitOBC.invoke(null, nmsItemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct CraftItemStack.", e);
        }
    }

    public static ItemStack getBukkitItemStack(Object minecraftItemStack) {
        if (craftNMSMethod != null) {
            return MinecraftReflection.getBukkitItemByMethod(minecraftItemStack);
        }
        if (craftNMSConstructor == null) {
            try {
                craftNMSConstructor = MinecraftReflection.getCraftItemStackClass().getConstructor(minecraftItemStack.getClass());
            }
            catch (Exception e) {
                if (!craftItemStackFailed) {
                    return MinecraftReflection.getBukkitItemByMethod(minecraftItemStack);
                }
                throw new RuntimeException("Cannot find CraftItemStack(net.minecraft.server.ItemStack).", e);
            }
        }
        try {
            return (ItemStack)craftNMSConstructor.newInstance(minecraftItemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct CraftItemStack.", e);
        }
    }

    private static ItemStack getBukkitItemByMethod(Object minecraftItemStack) {
        if (craftNMSMethod == null) {
            try {
                craftNMSMethod = MinecraftReflection.getCraftItemStackClass().getMethod("asCraftMirror", minecraftItemStack.getClass());
            }
            catch (Exception e) {
                craftItemStackFailed = true;
                throw new RuntimeException("Cannot find CraftItemStack.asCraftMirror(net.minecraft.server.ItemStack).", e);
            }
        }
        try {
            return (ItemStack)craftNMSMethod.invoke(null, minecraftItemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct CraftItemStack.", e);
        }
    }

    public static Object getMinecraftItemStack(ItemStack stack) {
        if (!MinecraftReflection.isCraftItemStack(stack)) {
            stack = MinecraftReflection.getBukkitItemStack(stack);
        }
        BukkitUnwrapper unwrapper = new BukkitUnwrapper();
        return unwrapper.unwrapItem(stack);
    }

    private static Class<?> getClass(String className) {
        try {
            return MinecraftReflection.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class " + className, e);
        }
    }

    public static Class<?> getCraftBukkitClass(String className) {
        if (craftbukkitPackage == null) {
            craftbukkitPackage = new CachedPackage(MinecraftReflection.getCraftBukkitPackage(), MinecraftReflection.getClassSource());
        }
        return craftbukkitPackage.getPackageClass(className);
    }

    public static Class<?> getMinecraftClass(String className) {
        if (minecraftPackage == null) {
            minecraftPackage = new CachedPackage(MinecraftReflection.getMinecraftPackage(), MinecraftReflection.getClassSource());
        }
        return minecraftPackage.getPackageClass(className);
    }

    private static Class<?> setMinecraftClass(String className, Class<?> clazz) {
        if (minecraftPackage == null) {
            minecraftPackage = new CachedPackage(MinecraftReflection.getMinecraftPackage(), MinecraftReflection.getClassSource());
        }
        minecraftPackage.setPackageClass(className, clazz);
        return clazz;
    }

    private static ClassSource getClassSource() {
        ErrorReporter reporter = ProtocolLibrary.getErrorReporter();
        if (classSource == null) {
            try {
                classSource = new RemappedClassSource().initialize();
                return classSource;
            }
            catch (RemappedClassSource.RemapperUnavaibleException e) {
                if (e.getReason() != RemappedClassSource.RemapperUnavaibleException.Reason.MCPC_NOT_PRESENT) {
                    reporter.reportWarning(MinecraftReflection.class, Report.newBuilder(REPORT_CANNOT_FIND_MCPC_REMAPPER));
                }
            }
            catch (Exception e) {
                reporter.reportWarning(MinecraftReflection.class, Report.newBuilder(REPORT_CANNOT_LOAD_CPC_REMAPPER));
            }
            classSource = ClassSource.fromClassLoader();
        }
        return classSource;
    }

    public static Class<?> getMinecraftClass(String className, String ... aliases) {
        try {
            return MinecraftReflection.getMinecraftClass(className);
        }
        catch (RuntimeException e) {
            Class<?> success = null;
            for (String alias : aliases) {
                try {
                    success = MinecraftReflection.getMinecraftClass(alias);
                    break;
                }
                catch (RuntimeException e1) {
                }
            }
            if (success != null) {
                minecraftPackage.setPackageClass(className, success);
                return success;
            }
            throw new RuntimeException(String.format("Unable to find %s (%s)", className, Joiner.on((String)", ").join((Object[])aliases)));
        }
    }

    public static Class<?> getMinecraftLibraryClass(String className) {
        if (libraryPackage == null) {
            libraryPackage = new CachedPackage("", MinecraftReflection.getClassSource());
        }
        return libraryPackage.getPackageClass(className);
    }

    private static Class<?> setMinecraftLibraryClass(String className, Class<?> clazz) {
        if (libraryPackage == null) {
            libraryPackage = new CachedPackage("", MinecraftReflection.getClassSource());
        }
        libraryPackage.setPackageClass(className, clazz);
        return clazz;
    }

    public static String getNetworkManagerName() {
        return MinecraftReflection.getNetworkManagerClass().getSimpleName();
    }

    public static String getNetLoginHandlerName() {
        return MinecraftReflection.getNetLoginHandlerClass().getSimpleName();
    }

    public static Object getPacketDataSerializer(Object buffer) {
        Class<?> packetSerializer = MinecraftReflection.getPacketDataSerializerClass();
        try {
            return packetSerializer.getConstructor(MinecraftReflection.getByteBufClass()).newInstance(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct packet serializer.", e);
        }
    }

    static {
        getBukkitEntityCache = Maps.newConcurrentMap();
    }
}

