/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.PacketConstructor;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.Util;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatExtensions {
    private ProtocolManager manager;
    private static volatile PacketConstructor chatConstructor;
    private static volatile Constructor<?> jsonConstructor;
    private static volatile MethodAccessor messageFactory;

    public ChatExtensions(ProtocolManager manager) {
        this.manager = manager;
    }

    public void sendMessageSilently(CommandSender receiver, String message) throws InvocationTargetException {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be NULL.");
        }
        if (message == null) {
            throw new IllegalArgumentException("message cannot be NULL.");
        }
        if (receiver instanceof Player) {
            this.sendMessageSilently((Player)receiver, message);
        } else {
            receiver.sendMessage(message);
        }
    }

    private void sendMessageSilently(Player player, String message) throws InvocationTargetException {
        try {
            for (PacketContainer packet : ChatExtensions.createChatPackets(message)) {
                this.manager.sendServerPacket(player, packet, false);
            }
        }
        catch (FieldAccessException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static PacketContainer[] createChatPackets(String message) {
        if (jsonConstructor != null) {
            if (chatConstructor == null) {
                Class<?> messageClass = jsonConstructor.getParameterTypes()[0];
                chatConstructor = PacketConstructor.DEFAULT.withPacket(PacketType.Play.Server.CHAT, new Object[]{messageClass});
                messageFactory = MinecraftReflection.isUsingNetty() ? Accessors.getMethodAccessor(MinecraftReflection.getCraftMessageClass(), "fromString", String.class) : Accessors.getMethodAccessor(FuzzyReflection.fromClass(messageClass).getMethod(FuzzyMethodContract.newBuilder().requireModifier(8).parameterCount(1).parameterExactType(String.class).returnTypeMatches(FuzzyMatchers.matchParent()).build()));
            }
            if (MinecraftReflection.isUsingNetty()) {
                Object[] components = (Object[])messageFactory.invoke(null, message);
                PacketContainer[] packets = new PacketContainer[components.length];
                for (int i = 0; i < components.length; ++i) {
                    packets[i] = chatConstructor.createPacket(components[i]);
                }
                return packets;
            }
            return new PacketContainer[]{chatConstructor.createPacket(messageFactory.invoke(null, message))};
        }
        if (chatConstructor == null) {
            chatConstructor = PacketConstructor.DEFAULT.withPacket(PacketType.Play.Server.CHAT, new Object[]{message});
        }
        return new PacketContainer[]{chatConstructor.createPacket(message)};
    }

    public void broadcastMessageSilently(String message, String permission) throws InvocationTargetException {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be NULL.");
        }
        for (Player player : Util.getOnlinePlayers()) {
            if (permission != null && !player.hasPermission(permission)) continue;
            this.sendMessageSilently(player, message);
        }
    }

    public static String[] toFlowerBox(String[] message, String marginChar, int marginWidth, int marginHeight) {
        int i;
        String[] output = new String[message.length + marginHeight * 2];
        int width = ChatExtensions.getMaximumLength(message);
        String topButtomMargin = Strings.repeat((String)marginChar, (int)(width + marginWidth * 2));
        String leftRightMargin = Strings.repeat((String)marginChar, (int)marginWidth);
        for (i = 0; i < message.length; ++i) {
            output[i + marginHeight] = leftRightMargin + Strings.padEnd((String)message[i], (int)width, (char)' ') + leftRightMargin;
        }
        for (i = 0; i < marginHeight; ++i) {
            output[i] = topButtomMargin;
            output[output.length - i - 1] = topButtomMargin;
        }
        return output;
    }

    private static int getMaximumLength(String[] lines) {
        int current = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (current >= lines[i].length()) continue;
            current = lines[i].length();
        }
        return current;
    }

    static Constructor<?> getJsonFormatConstructor() {
        Class chatPacket = PacketRegistry.getPacketClassFromType(PacketType.Play.Server.CHAT, true);
        List<Constructor<?>> list = FuzzyReflection.fromClass(chatPacket).getConstructorList(FuzzyMethodContract.newBuilder().parameterCount(1).parameterMatches(MinecraftReflection.getMinecraftObjectMatcher()).build());
        return (Constructor)Iterables.getFirst(list, null);
    }

    static {
        jsonConstructor = ChatExtensions.getJsonFormatConstructor();
    }
}

