/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.timing;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.timing.StatisticsStream;
import com.comphenix.protocol.timing.TimedListenerManager;
import com.comphenix.protocol.timing.TimedTracker;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;

public class TimingReportGenerator {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String META_STARTED = "Started: %s" + NEWLINE;
    private static final String META_STOPPED = "Stopped: %s (after %s seconds)" + NEWLINE;
    private static final String PLUGIN_HEADER = "=== PLUGIN %s ===" + NEWLINE;
    private static final String LISTENER_HEADER = " TYPE: %s " + NEWLINE;
    private static final String SEPERATION_LINE = " " + Strings.repeat((String)"-", (int)139) + NEWLINE;
    private static final String STATISTICS_HEADER = " Protocol:      Name:                         ID:                 Count:       Min (ms):       Max (ms):       Mean (ms):      Std (ms): " + NEWLINE;
    private static final String STATISTICS_ROW = " %-15s %-29s %-19s %-12d %-15.6f %-15.6f %-15.6f %.6f " + NEWLINE;
    private static final String SUM_MAIN_THREAD = " => Time on main thread: %.6f ms" + NEWLINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File destination, TimedListenerManager manager) throws IOException {
        BufferedWriter writer = null;
        Date started = manager.getStarted();
        Date stopped = manager.getStopped();
        long seconds = Math.abs((stopped.getTime() - started.getTime()) / 1000L);
        try {
            writer = Files.newWriter((File)destination, (Charset)Charsets.UTF_8);
            writer.write(String.format(META_STARTED, started));
            writer.write(String.format(META_STOPPED, stopped, seconds));
            writer.write(NEWLINE);
            for (String plugin : manager.getTrackedPlugins()) {
                writer.write(String.format(PLUGIN_HEADER, plugin));
                for (TimedListenerManager.ListenerType type : TimedListenerManager.ListenerType.values()) {
                    TimedTracker tracker = manager.getTracker(plugin, type);
                    if (tracker.getObservations() <= 0) continue;
                    writer.write(String.format(LISTENER_HEADER, new Object[]{type}));
                    writer.write(SEPERATION_LINE);
                    this.saveStatistics(writer, tracker, type);
                    writer.write(SEPERATION_LINE);
                }
                writer.write(NEWLINE);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    private void saveStatistics(Writer destination, TimedTracker tracker, TimedListenerManager.ListenerType type) throws IOException {
        Map<PacketType, StatisticsStream> streams = tracker.getStatistics();
        StatisticsStream sum = new StatisticsStream();
        int count = 0;
        destination.write(STATISTICS_HEADER);
        destination.write(SEPERATION_LINE);
        for (PacketType key : Sets.newTreeSet(streams.keySet())) {
            StatisticsStream stream = streams.get(key);
            if (stream == null || stream.getCount() <= 0) continue;
            this.printStatistic(destination, key, stream);
            ++count;
            sum = sum.add(stream);
        }
        if (count > 1) {
            this.printStatistic(destination, null, sum);
        }
        if (type == TimedListenerManager.ListenerType.SYNC_SERVER_SIDE) {
            destination.write(String.format(SUM_MAIN_THREAD, this.toMilli((double)sum.getCount() * sum.getMean())));
        }
    }

    private void printStatistic(Writer destination, PacketType key, StatisticsStream stream) throws IOException {
        destination.write(String.format(STATISTICS_ROW, key != null ? key.getProtocol() : "SUM", key != null ? key.name() : "-", key != null ? this.getPacketId(key) : "-", stream.getCount(), this.toMilli(stream.getMinimum()), this.toMilli(stream.getMaximum()), this.toMilli(stream.getMean()), this.toMilli(stream.getStandardDeviation())));
    }

    private String getPacketId(PacketType type) {
        return Strings.padStart((String)Integer.toString(type.getCurrentId()), (int)2, (char)'0') + " (Legacy: " + type.getLegacyId() + ")";
    }

    private double toMilli(double value) {
        return value / 1000000.0;
    }
}

