/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.instances;

import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.instances.InstanceProvider;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;

public class ExistingGenerator
implements InstanceProvider {
    private Node root = new Node(null, null, 0);

    private ExistingGenerator() {
    }

    public static ExistingGenerator fromObjectFields(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be NULL.");
        }
        return ExistingGenerator.fromObjectFields(object, object.getClass());
    }

    public static ExistingGenerator fromObjectFields(Object object, Class<?> type) {
        ExistingGenerator generator = new ExistingGenerator();
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be NULL.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be NULL.");
        }
        if (!type.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Type must be a superclass or be the same type.");
        }
        for (Field field : FuzzyReflection.fromClass(type, true).getFields()) {
            try {
                Object value = FieldUtils.readField(field, object, true);
                if (value == null) continue;
                generator.addObject(field.getType(), value);
            }
            catch (Exception e) {}
        }
        return generator;
    }

    public static ExistingGenerator fromObjectArray(Object[] values) {
        ExistingGenerator generator = new ExistingGenerator();
        for (Object value : values) {
            generator.addObject(value);
        }
        return generator;
    }

    private void addObject(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be NULL.");
        }
        this.addObject(value.getClass(), value);
    }

    private void addObject(Class<?> type, Object value) {
        Node node = this.getLeafNode(this.root, type, false);
        node.setValue(value);
    }

    private Node getLeafNode(Node start, Class<?> type, boolean readOnly) {
        Class<?>[] path = this.getHierachy(type);
        Node current = start;
        for (int i = 0; i < path.length; ++i) {
            Node next = this.getNext(current, path[i], readOnly);
            if (next == null && readOnly) {
                current = null;
                break;
            }
            current = next;
        }
        return current;
    }

    private Node getNext(Node current, Class<?> clazz, boolean readOnly) {
        Node next = current.getChild(clazz);
        if (next == null && !readOnly) {
            next = current.addChild(new Node(clazz, null, current.getLevel() + 1));
        }
        if (next != null && !readOnly && !clazz.isInterface()) {
            for (Class<?> clazzInterface : clazz.getInterfaces()) {
                this.getLeafNode(this.root, clazzInterface, readOnly).addChild(next);
            }
        }
        return next;
    }

    private Node getLowestLeaf(Node current) {
        Node candidate = current;
        for (Node child : current.getChildren()) {
            Node subtree = this.getLowestLeaf(child);
            if (subtree.getValue() == null || candidate.getLevel() >= subtree.getLevel()) continue;
            candidate = subtree;
        }
        return candidate;
    }

    private Class<?>[] getHierachy(Class<?> type) {
        LinkedList levels = Lists.newLinkedList();
        while (type != null) {
            levels.addFirst(type);
            type = type.getSuperclass();
        }
        return levels.toArray(new Class[0]);
    }

    @Override
    public Object create(@Nullable Class<?> type) {
        Node node = this.getLeafNode(this.root, type, true);
        if (node != null) {
            node = this.getLowestLeaf(node);
        }
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    private static final class Node {
        private Map<Class<?>, Node> children = new HashMap();
        private Class<?> key;
        private Object value;
        private int level;

        public Node(Class<?> key, Object value, int level) {
            this.key = key;
            this.value = value;
            this.level = level;
        }

        public Node addChild(Node node) {
            this.children.put(node.key, node);
            return node;
        }

        public int getLevel() {
            return this.level;
        }

        public Collection<Node> getChildren() {
            return this.children.values();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Node getChild(Class<?> clazz) {
            return this.children.get(clazz);
        }
    }
}

