/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassExactMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassRegexMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassSetMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.Member;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class FuzzyMatchers {
    private static AbstractFuzzyMatcher<Class<?>> MATCH_ALL = new AbstractFuzzyMatcher<Class<?>>(){

        @Override
        public boolean isMatch(Class<?> value, Object parent) {
            return true;
        }

        @Override
        protected int calculateRoundNumber() {
            return 0;
        }
    };

    private FuzzyMatchers() {
    }

    public static AbstractFuzzyMatcher<Class<?>> matchArray(final @Nonnull AbstractFuzzyMatcher<Class<?>> componentMatcher) {
        Preconditions.checkNotNull(componentMatcher, (Object)"componentMatcher cannot be NULL.");
        return new AbstractFuzzyMatcher<Class<?>>(){

            @Override
            public boolean isMatch(Class<?> value, Object parent) {
                return value.isArray() && componentMatcher.isMatch(value.getComponentType(), parent);
            }

            @Override
            protected int calculateRoundNumber() {
                return -1;
            }
        };
    }

    public static AbstractFuzzyMatcher<Class<?>> matchAll() {
        return MATCH_ALL;
    }

    public static AbstractFuzzyMatcher<Class<?>> matchExact(Class<?> matcher) {
        return new ClassExactMatcher(matcher, ClassExactMatcher.Options.MATCH_EXACT);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchAnyOf(Class<?> ... classes) {
        return FuzzyMatchers.matchAnyOf(Sets.newHashSet((Object[])classes));
    }

    public static AbstractFuzzyMatcher<Class<?>> matchAnyOf(Set<Class<?>> classes) {
        return new ClassSetMatcher(classes);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchSuper(Class<?> matcher) {
        return new ClassExactMatcher(matcher, ClassExactMatcher.Options.MATCH_SUPER);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchDerived(Class<?> matcher) {
        return new ClassExactMatcher(matcher, ClassExactMatcher.Options.MATCH_DERIVED);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchRegex(Pattern regex, int priority) {
        return new ClassRegexMatcher(regex, priority);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchRegex(String regex, int priority) {
        return FuzzyMatchers.matchRegex(Pattern.compile(regex), priority);
    }

    public static AbstractFuzzyMatcher<Class<?>> matchParent() {
        return new AbstractFuzzyMatcher<Class<?>>(){

            @Override
            public boolean isMatch(Class<?> value, Object parent) {
                if (parent instanceof Member) {
                    return ((Member)parent).getDeclaringClass().equals(value);
                }
                if (parent instanceof Class) {
                    return parent.equals(value);
                }
                return false;
            }

            @Override
            protected int calculateRoundNumber() {
                return -100;
            }

            public String toString() {
                return "match parent class";
            }

            public int hashCode() {
                return 0;
            }

            public boolean equals(Object obj) {
                return obj != null && obj.getClass() == this.getClass();
            }
        };
    }

    static boolean checkPattern(Pattern a, Pattern b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.pattern().equals(b.pattern());
    }
}

