/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.google.common.collect.Maps;
import java.util.Map;

public class BukkitCloner
implements Cloner {
    private final Map<Integer, Class<?>> clonableClasses = Maps.newConcurrentMap();

    public BukkitCloner() {
        this.addClass(0, MinecraftReflection.getItemStackClass());
        this.addClass(1, MinecraftReflection.getDataWatcherClass());
        try {
            this.addClass(2, MinecraftReflection.getBlockPositionClass());
        }
        catch (Throwable ex) {
            // empty catch block
        }
        try {
            this.addClass(3, MinecraftReflection.getChunkPositionClass());
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (MinecraftReflection.isUsingNetty()) {
            this.addClass(4, MinecraftReflection.getServerPingClass());
        }
        if (MinecraftReflection.watcherObjectExists()) {
            this.addClass(5, MinecraftReflection.getDataWatcherSerializerClass());
            this.addClass(6, MinecraftReflection.getMinecraftKeyClass());
        }
        try {
            this.addClass(7, MinecraftReflection.getIBlockDataClass());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addClass(int id, Class<?> clazz) {
        if (clazz != null) {
            this.clonableClasses.put(id, clazz);
        }
    }

    private int findMatchingClass(Class<?> type) {
        for (Map.Entry<Integer, Class<?>> entry : this.clonableClasses.entrySet()) {
            if (!entry.getValue().isAssignableFrom(type)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        return this.findMatchingClass(source.getClass()) >= 0;
    }

    @Override
    public Object clone(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be NULL.");
        }
        switch (this.findMatchingClass(source.getClass())) {
            case 0: {
                return MinecraftReflection.getMinecraftItemStack(MinecraftReflection.getBukkitItemStack(source).clone());
            }
            case 1: {
                EquivalentConverter<WrappedDataWatcher> dataConverter = BukkitConverters.getDataWatcherConverter();
                return dataConverter.getGeneric(this.clonableClasses.get(1), dataConverter.getSpecific(source).deepClone());
            }
            case 2: {
                EquivalentConverter<BlockPosition> blockConverter = BlockPosition.getConverter();
                return blockConverter.getGeneric(this.clonableClasses.get(2), blockConverter.getSpecific(source));
            }
            case 3: {
                EquivalentConverter<ChunkPosition> chunkConverter = ChunkPosition.getConverter();
                return chunkConverter.getGeneric(this.clonableClasses.get(3), chunkConverter.getSpecific(source));
            }
            case 4: {
                EquivalentConverter<WrappedServerPing> serverConverter = BukkitConverters.getWrappedServerPingConverter();
                return serverConverter.getGeneric(this.clonableClasses.get(4), serverConverter.getSpecific(source).deepClone());
            }
            case 5: {
                return source;
            }
            case 6: {
                EquivalentConverter<MinecraftKey> keyConverter = MinecraftKey.getConverter();
                return keyConverter.getGeneric(this.clonableClasses.get(6), keyConverter.getSpecific(source));
            }
            case 7: {
                EquivalentConverter<WrappedBlockData> blockDataConverter = BukkitConverters.getWrappedBlockDataConverter();
                return blockDataConverter.getGeneric(this.clonableClasses.get(7), blockDataConverter.getSpecific(source).deepClone());
            }
        }
        throw new IllegalArgumentException("Cannot clone objects of type " + source.getClass());
    }
}

