/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public class IntEnum {
    protected BiMap<Integer, String> members = HashBiMap.create();

    public IntEnum() {
        this.registerAll();
    }

    protected void registerAll() {
        try {
            for (Field entry : this.getClass().getFields()) {
                if (!entry.getType().equals(Integer.TYPE)) continue;
                this.registerMember(entry.getInt(this), entry.getName());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void registerMember(int id, String name) {
        this.members.put((Object)id, (Object)name);
    }

    public boolean hasMember(int id) {
        return this.members.containsKey((Object)id);
    }

    public Integer valueOf(String name) {
        return (Integer)this.members.inverse().get((Object)name);
    }

    public String getDeclaredName(Integer id) {
        return (String)this.members.get((Object)id);
    }

    public Set<Integer> values() {
        return new HashSet<Integer>(this.members.keySet());
    }
}

