/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class ExactReflection {
    private Class<?> source;
    private boolean forceAccess;

    private ExactReflection(Class<?> source, boolean forceAccess) {
        this.source = (Class)Preconditions.checkNotNull(source, (Object)"source class cannot be NULL");
        this.forceAccess = forceAccess;
    }

    public static ExactReflection fromClass(Class<?> source) {
        return ExactReflection.fromClass(source, false);
    }

    public static ExactReflection fromClass(Class<?> source, boolean forceAccess) {
        return new ExactReflection(source, forceAccess);
    }

    public static ExactReflection fromObject(Object reference) {
        return new ExactReflection(reference.getClass(), false);
    }

    public static ExactReflection fromObject(Object reference, boolean forceAccess) {
        return new ExactReflection(reference.getClass(), forceAccess);
    }

    public Method getMethod(String methodName, Class<?> ... parameters) {
        return this.getMethod(this.source, methodName, parameters);
    }

    private Method getMethod(Class<?> instanceClass, String methodName, Class<?> ... parameters) {
        for (Method method : instanceClass.getDeclaredMethods()) {
            if (!this.forceAccess && !Modifier.isPublic(method.getModifiers()) || methodName != null && !method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), parameters)) continue;
            method.setAccessible(true);
            return method;
        }
        if (instanceClass.getSuperclass() != null) {
            return this.getMethod(instanceClass.getSuperclass(), methodName, parameters);
        }
        throw new IllegalArgumentException(String.format("Unable to find method %s (%s) in %s.", methodName, Arrays.asList(parameters), this.source));
    }

    public Field getField(String fieldName) {
        return this.getField(this.source, fieldName);
    }

    private Field getField(Class<?> instanceClass, @Nonnull String fieldName) {
        for (Field field : instanceClass.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            field.setAccessible(true);
            return field;
        }
        if (instanceClass.getSuperclass() != null) {
            return this.getField(instanceClass.getSuperclass(), fieldName);
        }
        throw new IllegalArgumentException(String.format("Unable to find field %s in %s.", fieldName, this.source));
    }

    public ExactReflection forceAccess() {
        return new ExactReflection(this.source, true);
    }

    public boolean isForceAccess() {
        return this.forceAccess;
    }

    public Class<?> getSource() {
        return this.source;
    }
}

