/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.server;

import com.comphenix.protocol.concurrency.BlockingHashMap;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.server.AbstractInputStreamLookup;
import com.comphenix.protocol.injector.server.SocketInjector;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FieldUtils;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.google.common.collect.MapMaker;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Server;

class InputStreamReflectLookup
extends AbstractInputStreamLookup {
    private static Field filteredInputField;
    private static final long DEFAULT_TIMEOUT = 2000L;
    protected BlockingHashMap<SocketAddress, SocketInjector> addressLookup = new BlockingHashMap();
    protected ConcurrentMap<InputStream, SocketAddress> inputLookup = new MapMaker().weakValues().makeMap();
    private final long injectorTimeout;

    public InputStreamReflectLookup(ErrorReporter reporter, Server server) {
        this(reporter, server, 2000L);
    }

    public InputStreamReflectLookup(ErrorReporter reporter, Server server, long injectorTimeout) {
        super(reporter, server);
        this.injectorTimeout = injectorTimeout;
    }

    @Override
    public void inject(Object container) {
    }

    @Override
    public SocketInjector peekSocketInjector(SocketAddress address) {
        try {
            return this.addressLookup.get(address, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public SocketInjector waitSocketInjector(SocketAddress address) {
        try {
            return this.addressLookup.get(address, this.injectorTimeout, TimeUnit.MILLISECONDS, true);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Impossible exception occured!", e);
        }
    }

    @Override
    public SocketInjector waitSocketInjector(Socket socket) {
        return this.waitSocketInjector(socket.getRemoteSocketAddress());
    }

    @Override
    public SocketInjector waitSocketInjector(InputStream input) {
        try {
            SocketAddress address = this.waitSocketAddress(input);
            if (address != null) {
                return this.waitSocketInjector(address);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Cannot find or access socket field for " + input, e);
        }
    }

    private SocketAddress waitSocketAddress(InputStream stream) throws IllegalAccessException {
        if (stream instanceof FilterInputStream) {
            return this.waitSocketAddress(InputStreamReflectLookup.getInputStream((FilterInputStream)stream));
        }
        SocketAddress result = (SocketAddress)this.inputLookup.get(stream);
        if (result == null) {
            Socket socket = InputStreamReflectLookup.lookupSocket(stream);
            result = socket.getRemoteSocketAddress();
            this.inputLookup.put(stream, result);
        }
        return result;
    }

    protected static InputStream getInputStream(FilterInputStream filtered) {
        if (filteredInputField == null) {
            filteredInputField = FuzzyReflection.fromClass(FilterInputStream.class, true).getFieldByType("in", InputStream.class);
        }
        InputStream current = filtered;
        try {
            while (current instanceof FilterInputStream) {
                current = (InputStream)FieldUtils.readField(filteredInputField, current, true);
            }
            return current;
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Cannot access filtered input field.", e);
        }
    }

    @Override
    public void setSocketInjector(SocketAddress address, SocketInjector injector) {
        if (address == null) {
            throw new IllegalArgumentException("address cannot be NULL");
        }
        if (injector == null) {
            throw new IllegalArgumentException("injector cannot be NULL.");
        }
        SocketInjector previous = this.addressLookup.put(address, injector);
        if (previous != null) {
            this.onPreviousSocketOverwritten(previous, injector);
        }
    }

    @Override
    public void cleanupAll() {
    }

    private static Socket lookupSocket(InputStream stream) throws IllegalAccessException {
        if (stream instanceof FilterInputStream) {
            return InputStreamReflectLookup.lookupSocket(InputStreamReflectLookup.getInputStream((FilterInputStream)stream));
        }
        Field socketField = FuzzyReflection.fromObject(stream, true).getFieldByType("socket", Socket.class);
        return (Socket)FieldUtils.readField(socketField, stream, true);
    }
}

